cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;
    },

    onBtnScreenShoot:function(){
        console.log("cut start");
        var size = cc.director.getWinSize();
        var fileName = "result_share.jpg";
        var fullPath = jsb.fileUtils.getWritablePath() + fileName;
        if(jsb.fileUtils.isFileExist(fullPath)){
            jsb.fileUtils.removeFile(fullPath);
        }
        var texture = new cc.RenderTexture(Math.floor(size.width), Math.floor(size.height));
        texture.setPosition(cc.p(size.width/2, size.height/2));
        texture.begin();
        cc.director.getRunningScene().visit();
        texture.end();
        console.log("cut start1");
        try{
            texture.saveToFile(fileName,cc.IMAGE_FORMAT_PNG,true,function(err){
                console.log("PNG");
                console(err);
            });
        }
        catch(e){
            console.log("png err:");
            console.log(e);
        }
        console.log("cut start2");
        try{
            texture.saveToFile(fileName,cc.IMAGE_FORMAT_JPG);
        }
        catch(e){
            console.log("JPG err:");
            console.log(e);
        }
    },

    // called every frame
    update: function (dt) {

    },
});
