var logs = []
var oldConsole = {};

oldConsole.trace = console.trace
oldConsole.log = console.log
oldConsole.success = console.success
oldConsole.failed = console.failed
oldConsole.info = console.info
oldConsole.warn = console.warn
oldConsole.error = console.error

module.exports = {
    'open': function (event) {
        console.trace = function(e, r, ...t) {
            r = t.length ? Editor.util.format.apply(Editor.util, [r, ...t]) : "" + r;
            var l = new Error("dummy").stack.split("\n");
            l.shift();
            l[0] = r;
            r = l.join("\n");
            Editor.Ipc.sendToMain("editor:renderer-console-trace", e, r)
        },
        console.log = function(e, ...r) {
            e = r.length ? Editor.util.format.apply(Editor.util, arguments) : "" + e; 
            Editor.Ipc.sendToMain("editor:renderer-console-log", e);
        },
        console.success = function(e, ...r) {
            e = r.length ? Editor.util.format.apply(Editor.util, arguments) : "" + e;    
            Editor.Ipc.sendToMain("editor:renderer-console-success", e);
        },
        console.failed = function(e, ...r) {
            e = r.length ? Editor.util.format.apply(Editor.util, arguments) : "" + e;
            Editor.Ipc.sendToMain("editor:renderer-console-failed", e);
        },
        console.info = function(e, ...r) {
            e = r.length ? Editor.util.format.apply(Editor.util, arguments) : "" + e,    
            Editor.Ipc.sendToMain("editor:renderer-console-info", e);
        },
        console.warn = function(e, ...r) {
            e = r.length ? Editor.util.format.apply(Editor.util, arguments) : "" + e;    
            Editor.Ipc.sendToMain("editor:renderer-console-warn", e);
        },
        console.error = function(e, ...r) {
            e = r.length ? Editor.util.format.apply(Editor.util, arguments) : "" + e;    
            var t = new Error("dummy").stack.split("\n");
            t.shift(),
            t[0] = e,
            e = t.join("\n"),
            Editor.Ipc.sendToMain("editor:renderer-console-error", e)
        };
    },
    'close': function (event) {
        console.trace = oldConsole.trace
        console.log = oldConsole.log
        console.success = oldConsole.success
        console.failed = oldConsole.failed
        console.info = oldConsole.info
        console.warn = oldConsole.warn
        console.error = oldConsole.error
    }    
};