
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Palette.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '288ffZXrqBOzqVdKm1yvTBY', 'Palette');
// Palette.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Palette = /** @class */ (function (_super) {
    __extends(Palette, _super);
    function Palette() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.hueSprite = null;
        _this.huePointNode = null;
        _this.colorBoardSprite = null;
        _this.circleNode = null;
        _this.rSlider = null;
        _this.rEditBox = null;
        _this.gSlider = null;
        _this.gEditBox = null;
        _this.bSlider = null;
        _this.bEditBox = null;
        _this.h = 0;
        _this.s = 100;
        _this.v = 100;
        _this.colorBoardData = null;
        _this.colorBoardTexture = null;
        return _this;
        // update (dt) {}
    }
    Palette.prototype.onLoad = function () {
        this.colorBoardTexture = new cc.Texture2D();
        this.createHueData();
        this.createColorBoardData();
        this.initRgbNode();
        this.addEvent();
    };
    Palette.prototype.createHueData = function () {
        var texture2D = new cc.Texture2D();
        var hueData = new Uint8Array(360 * 4);
        for (var i = 0; i < 360; i++) {
            var color = this.hsv2rgb(i, 100, 100);
            hueData[i * 4] = color.getR();
            hueData[i * 4 + 1] = color.getG();
            hueData[i * 4 + 2] = color.getB();
            hueData[i * 4 + 3] = color.getA();
        }
        texture2D.initWithData(hueData, cc.Texture2D.PixelFormat.RGBA8888, 1, 360);
        this.hueSprite.spriteFrame = new cc.SpriteFrame(texture2D);
    };
    Palette.prototype.createColorBoardData = function (isFromRgba) {
        if (isFromRgba === void 0) { isFromRgba = false; }
        this.colorBoardData = new Uint8Array(101 * 101 * 4);
        for (var i = 0; i <= 100; i++) {
            for (var j = 0; j <= 100; j++) {
                var color = this.hsv2rgb(this.h, j, 100 - i);
                var index = (i * 101 + j) * 4;
                this.colorBoardData[index] = color.getR();
                this.colorBoardData[index + 1] = color.getG();
                this.colorBoardData[index + 2] = color.getB();
                this.colorBoardData[index + 3] = color.getA();
            }
        }
        this.colorBoardTexture.initWithData(this.colorBoardData, cc.Texture2D.PixelFormat.RGBA8888, 101, 101);
        this.colorBoardSprite.spriteFrame = new cc.SpriteFrame(this.colorBoardTexture);
        this.circleNode.position = cc.v2(this.s / 100 * this.colorBoardSprite.node.width, this.v / 100 * this.colorBoardSprite.node.height);
        this.setCircleColor();
        if (!isFromRgba) {
            this.initRgbNode();
        }
    };
    Palette.prototype.addEvent = function () {
        this.hueSprite.node.on(cc.Node.EventType.TOUCH_START, this.onHueTouch, this);
        this.hueSprite.node.on(cc.Node.EventType.TOUCH_MOVE, this.onHueTouch, this);
        this.huePointNode.on(cc.Node.EventType.TOUCH_MOVE, this.onHueTouch, this);
        this.colorBoardSprite.node.on(cc.Node.EventType.TOUCH_START, this.onColorBoardTouch, this);
        this.colorBoardSprite.node.on(cc.Node.EventType.TOUCH_MOVE, this.onColorBoardTouch, this);
        this.rSlider.node.on('slide', this.rgbChanged, this);
        this.gSlider.node.on('slide', this.rgbChanged, this);
        this.bSlider.node.on('slide', this.rgbChanged, this);
        this.rEditBox.node.on("editing-did-ended", this.editTextEnd, this);
        this.gEditBox.node.on("editing-did-ended", this.editTextEnd, this);
        this.bEditBox.node.on("editing-did-ended", this.editTextEnd, this);
    };
    Palette.prototype.editTextEnd = function () {
        var rText = this.rEditBox.string;
        var r = parseInt(rText);
        if (isNaN(r)) {
            r = 255;
        }
        r = Math.max(0, Math.min(r, 255));
        this.rEditBox.string = r + "";
        this.rSlider.progress = r / 255;
        var gText = this.gEditBox.string;
        var g = parseInt(gText);
        if (isNaN(g)) {
            g = 255;
        }
        g = Math.max(0, Math.min(g, 255));
        this.gEditBox.string = g + "";
        this.gSlider.progress = g / 255;
        var bText = this.bEditBox.string;
        var b = parseInt(bText);
        if (isNaN(b)) {
            b = 255;
        }
        b = Math.max(0, Math.min(b, 255));
        this.bEditBox.string = b + "";
        this.bSlider.progress = b / 255;
        var hsv = this.rgb2hsv(r, g, b);
        this.h = hsv[0];
        this.s = hsv[1];
        this.v = hsv[2];
        this.huePointNode.y = Math.round(this.hueSprite.node.height / 2 - this.h / 360 * this.hueSprite.node.height);
        this.createColorBoardData(true);
    };
    Palette.prototype.initRgbNode = function () {
        var curColor = this.hsv2rgb(this.h, this.s, this.v);
        this.rSlider.progress = curColor.getR() / 255;
        this.rEditBox.string = curColor.getR() + "";
        this.gSlider.progress = curColor.getG() / 255;
        this.gEditBox.string = curColor.getG() + "";
        this.bSlider.progress = curColor.getB() / 255;
        this.bEditBox.string = curColor.getB() + "";
    };
    Palette.prototype.rgbChanged = function () {
        var r = Math.round(255 * this.rSlider.progress);
        this.rEditBox.string = r + "";
        var g = Math.round(255 * this.gSlider.progress);
        this.gEditBox.string = g + "";
        var b = Math.round(255 * this.bSlider.progress);
        this.bEditBox.string = b + "";
        var hsv = this.rgb2hsv(r, g, b);
        this.h = hsv[0];
        this.s = hsv[1];
        this.v = hsv[2];
        this.huePointNode.y = Math.round(this.hueSprite.node.height / 2 - this.h / 360 * this.hueSprite.node.height);
        this.createColorBoardData(true);
    };
    Palette.prototype.onHueTouch = function (event) {
        var pos = this.hueSprite.node.convertToNodeSpace(event.touch.getLocation());
        var index = Math.round((this.hueSprite.node.height - pos.y) / this.hueSprite.node.height * 360);
        index = Math.max(0, Math.min(index, 359));
        this.h = index;
        this.huePointNode.y = Math.round(this.hueSprite.node.height / 2 - index / 360 * this.hueSprite.node.height);
        this.createColorBoardData();
    };
    Palette.prototype.onColorBoardTouch = function (event) {
        var pos = this.colorBoardSprite.node.convertToNodeSpace(event.touch.getLocation());
        pos.x = Math.max(0, Math.min(pos.x, this.colorBoardSprite.node.width));
        pos.y = Math.max(0, Math.min(pos.y, this.colorBoardSprite.node.height));
        this.circleNode.position = pos;
        this.s = Math.round(pos.x / this.colorBoardSprite.node.width * 100);
        this.v = Math.round(pos.y / this.colorBoardSprite.node.height * 100);
        this.s = Math.max(0, Math.min(this.s, 100));
        this.v = Math.max(0, Math.min(this.v, 100));
        this.setCircleColor();
        this.initRgbNode();
    };
    Palette.prototype.setCircleColor = function () {
        var curColor = this.hsv2rgb(this.h, this.s, this.v);
        var isBlack = .299 * curColor.getR() + .578 * curColor.getG() + .114 * curColor.getB() >= 192;
        this.circleNode.color = isBlack ? cc.Color.BLACK : cc.Color.WHITE;
    };
    Palette.prototype.hsv2rgb = function (h, s, v) {
        h /= 1;
        s /= 100;
        v /= 100;
        var r = 0;
        var g = 0;
        var b = 0;
        if (s === 0) {
            r = g = b = v;
        }
        else {
            var _h = h / 60;
            var i = Math.floor(_h);
            var f = _h - i;
            var p = v * (1 - s);
            var q = v * (1 - f * s);
            var t = v * (1 - (1 - f) * s);
            switch (i) {
                case 0:
                    r = v;
                    g = t;
                    b = p;
                    break;
                case 1:
                    r = q;
                    g = v;
                    b = p;
                    break;
                case 2:
                    r = p;
                    g = v;
                    b = t;
                    break;
                case 3:
                    r = p;
                    g = q;
                    b = v;
                    break;
                case 4:
                    r = t;
                    g = p;
                    b = v;
                    break;
                case 5:
                    r = v;
                    g = p;
                    b = q;
                    break;
            }
        }
        return cc.color(Math.round(r * 255), Math.round(g * 255), Math.round(b * 255), 255);
    };
    Palette.prototype.rgb2hsv = function (r, g, b) {
        r /= 255;
        g /= 255;
        b /= 255;
        var max = Math.max(r, g, b);
        var min = Math.min(r, g, b);
        var diff = max - min;
        var h = 0;
        var v = max;
        var s = max === 0 ? 0 : diff / max; // h
        if (max === min) {
            h = 0;
        }
        else if (max === r && g >= b) {
            h = 60 * ((g - b) / diff);
        }
        else if (max === r && g < b) {
            h = 60 * ((g - b) / diff) + 360;
        }
        else if (max === g) {
            h = 60 * ((b - r) / diff) + 120;
        }
        else if (max === b) {
            h = 60 * ((r - g) / diff) + 240;
        }
        return [Math.round(h), Math.round(s * 100), Math.round(v * 100)];
    };
    __decorate([
        property(cc.Sprite)
    ], Palette.prototype, "hueSprite", void 0);
    __decorate([
        property(cc.Node)
    ], Palette.prototype, "huePointNode", void 0);
    __decorate([
        property(cc.Sprite)
    ], Palette.prototype, "colorBoardSprite", void 0);
    __decorate([
        property(cc.Node)
    ], Palette.prototype, "circleNode", void 0);
    __decorate([
        property(cc.Slider)
    ], Palette.prototype, "rSlider", void 0);
    __decorate([
        property(cc.EditBox)
    ], Palette.prototype, "rEditBox", void 0);
    __decorate([
        property(cc.Slider)
    ], Palette.prototype, "gSlider", void 0);
    __decorate([
        property(cc.EditBox)
    ], Palette.prototype, "gEditBox", void 0);
    __decorate([
        property(cc.Slider)
    ], Palette.prototype, "bSlider", void 0);
    __decorate([
        property(cc.EditBox)
    ], Palette.prototype, "bEditBox", void 0);
    Palette = __decorate([
        ccclass
    ], Palette);
    return Palette;
}(cc.Component));
exports.default = Palette;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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