"use strict";
cc._RF.push(module, '288ffZXrqBOzqVdKm1yvTBY', 'Palette');
// Palette.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Palette = /** @class */ (function (_super) {
    __extends(Palette, _super);
    function Palette() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.hueSprite = null;
        _this.huePointNode = null;
        _this.colorBoardSprite = null;
        _this.circleNode = null;
        _this.rSlider = null;
        _this.rEditBox = null;
        _this.gSlider = null;
        _this.gEditBox = null;
        _this.bSlider = null;
        _this.bEditBox = null;
        _this.h = 0;
        _this.s = 100;
        _this.v = 100;
        _this.colorBoardData = null;
        _this.colorBoardTexture = null;
        return _this;
        // update (dt) {}
    }
    Palette.prototype.onLoad = function () {
        this.colorBoardTexture = new cc.Texture2D();
        this.createHueData();
        this.createColorBoardData();
        this.initRgbNode();
        this.addEvent();
    };
    Palette.prototype.createHueData = function () {
        var texture2D = new cc.Texture2D();
        var hueData = new Uint8Array(360 * 4);
        for (var i = 0; i < 360; i++) {
            var color = this.hsv2rgb(i, 100, 100);
            hueData[i * 4] = color.getR();
            hueData[i * 4 + 1] = color.getG();
            hueData[i * 4 + 2] = color.getB();
            hueData[i * 4 + 3] = color.getA();
        }
        texture2D.initWithData(hueData, cc.Texture2D.PixelFormat.RGBA8888, 1, 360);
        this.hueSprite.spriteFrame = new cc.SpriteFrame(texture2D);
    };
    Palette.prototype.createColorBoardData = function (isFromRgba) {
        if (isFromRgba === void 0) { isFromRgba = false; }
        this.colorBoardData = new Uint8Array(101 * 101 * 4);
        for (var i = 0; i <= 100; i++) {
            for (var j = 0; j <= 100; j++) {
                var color = this.hsv2rgb(this.h, j, 100 - i);
                var index = (i * 101 + j) * 4;
                this.colorBoardData[index] = color.getR();
                this.colorBoardData[index + 1] = color.getG();
                this.colorBoardData[index + 2] = color.getB();
                this.colorBoardData[index + 3] = color.getA();
            }
        }
        this.colorBoardTexture.initWithData(this.colorBoardData, cc.Texture2D.PixelFormat.RGBA8888, 101, 101);
        this.colorBoardSprite.spriteFrame = new cc.SpriteFrame(this.colorBoardTexture);
        this.circleNode.position = cc.v2(this.s / 100 * this.colorBoardSprite.node.width, this.v / 100 * this.colorBoardSprite.node.height);
        this.setCircleColor();
        if (!isFromRgba) {
            this.initRgbNode();
        }
    };
    Palette.prototype.addEvent = function () {
        this.hueSprite.node.on(cc.Node.EventType.TOUCH_START, this.onHueTouch, this);
        this.hueSprite.node.on(cc.Node.EventType.TOUCH_MOVE, this.onHueTouch, this);
        this.huePointNode.on(cc.Node.EventType.TOUCH_MOVE, this.onHueTouch, this);
        this.colorBoardSprite.node.on(cc.Node.EventType.TOUCH_START, this.onColorBoardTouch, this);
        this.colorBoardSprite.node.on(cc.Node.EventType.TOUCH_MOVE, this.onColorBoardTouch, this);
        this.rSlider.node.on('slide', this.rgbChanged, this);
        this.gSlider.node.on('slide', this.rgbChanged, this);
        this.bSlider.node.on('slide', this.rgbChanged, this);
        this.rEditBox.node.on("editing-did-ended", this.editTextEnd, this);
        this.gEditBox.node.on("editing-did-ended", this.editTextEnd, this);
        this.bEditBox.node.on("editing-did-ended", this.editTextEnd, this);
    };
    Palette.prototype.editTextEnd = function () {
        var rText = this.rEditBox.string;
        var r = parseInt(rText);
        if (isNaN(r)) {
            r = 255;
        }
        r = Math.max(0, Math.min(r, 255));
        this.rEditBox.string = r + "";
        this.rSlider.progress = r / 255;
        var gText = this.gEditBox.string;
        var g = parseInt(gText);
        if (isNaN(g)) {
            g = 255;
        }
        g = Math.max(0, Math.min(g, 255));
        this.gEditBox.string = g + "";
        this.gSlider.progress = g / 255;
        var bText = this.bEditBox.string;
        var b = parseInt(bText);
        if (isNaN(b)) {
            b = 255;
        }
        b = Math.max(0, Math.min(b, 255));
        this.bEditBox.string = b + "";
        this.bSlider.progress = b / 255;
        var hsv = this.rgb2hsv(r, g, b);
        this.h = hsv[0];
        this.s = hsv[1];
        this.v = hsv[2];
        this.huePointNode.y = Math.round(this.hueSprite.node.height / 2 - this.h / 360 * this.hueSprite.node.height);
        this.createColorBoardData(true);
    };
    Palette.prototype.initRgbNode = function () {
        var curColor = this.hsv2rgb(this.h, this.s, this.v);
        this.rSlider.progress = curColor.getR() / 255;
        this.rEditBox.string = curColor.getR() + "";
        this.gSlider.progress = curColor.getG() / 255;
        this.gEditBox.string = curColor.getG() + "";
        this.bSlider.progress = curColor.getB() / 255;
        this.bEditBox.string = curColor.getB() + "";
    };
    Palette.prototype.rgbChanged = function () {
        var r = Math.round(255 * this.rSlider.progress);
        this.rEditBox.string = r + "";
        var g = Math.round(255 * this.gSlider.progress);
        this.gEditBox.string = g + "";
        var b = Math.round(255 * this.bSlider.progress);
        this.bEditBox.string = b + "";
        var hsv = this.rgb2hsv(r, g, b);
        this.h = hsv[0];
        this.s = hsv[1];
        this.v = hsv[2];
        this.huePointNode.y = Math.round(this.hueSprite.node.height / 2 - this.h / 360 * this.hueSprite.node.height);
        this.createColorBoardData(true);
    };
    Palette.prototype.onHueTouch = function (event) {
        var pos = this.hueSprite.node.convertToNodeSpace(event.touch.getLocation());
        var index = Math.round((this.hueSprite.node.height - pos.y) / this.hueSprite.node.height * 360);
        index = Math.max(0, Math.min(index, 359));
        this.h = index;
        this.huePointNode.y = Math.round(this.hueSprite.node.height / 2 - index / 360 * this.hueSprite.node.height);
        this.createColorBoardData();
    };
    Palette.prototype.onColorBoardTouch = function (event) {
        var pos = this.colorBoardSprite.node.convertToNodeSpace(event.touch.getLocation());
        pos.x = Math.max(0, Math.min(pos.x, this.colorBoardSprite.node.width));
        pos.y = Math.max(0, Math.min(pos.y, this.colorBoardSprite.node.height));
        this.circleNode.position = pos;
        this.s = Math.round(pos.x / this.colorBoardSprite.node.width * 100);
        this.v = Math.round(pos.y / this.colorBoardSprite.node.height * 100);
        this.s = Math.max(0, Math.min(this.s, 100));
        this.v = Math.max(0, Math.min(this.v, 100));
        this.setCircleColor();
        this.initRgbNode();
    };
    Palette.prototype.setCircleColor = function () {
        var curColor = this.hsv2rgb(this.h, this.s, this.v);
        var isBlack = .299 * curColor.getR() + .578 * curColor.getG() + .114 * curColor.getB() >= 192;
        this.circleNode.color = isBlack ? cc.Color.BLACK : cc.Color.WHITE;
    };
    Palette.prototype.hsv2rgb = function (h, s, v) {
        h /= 1;
        s /= 100;
        v /= 100;
        var r = 0;
        var g = 0;
        var b = 0;
        if (s === 0) {
            r = g = b = v;
        }
        else {
            var _h = h / 60;
            var i = Math.floor(_h);
            var f = _h - i;
            var p = v * (1 - s);
            var q = v * (1 - f * s);
            var t = v * (1 - (1 - f) * s);
            switch (i) {
                case 0:
                    r = v;
                    g = t;
                    b = p;
                    break;
                case 1:
                    r = q;
                    g = v;
                    b = p;
                    break;
                case 2:
                    r = p;
                    g = v;
                    b = t;
                    break;
                case 3:
                    r = p;
                    g = q;
                    b = v;
                    break;
                case 4:
                    r = t;
                    g = p;
                    b = v;
                    break;
                case 5:
                    r = v;
                    g = p;
                    b = q;
                    break;
            }
        }
        return cc.color(Math.round(r * 255), Math.round(g * 255), Math.round(b * 255), 255);
    };
    Palette.prototype.rgb2hsv = function (r, g, b) {
        r /= 255;
        g /= 255;
        b /= 255;
        var max = Math.max(r, g, b);
        var min = Math.min(r, g, b);
        var diff = max - min;
        var h = 0;
        var v = max;
        var s = max === 0 ? 0 : diff / max; // h
        if (max === min) {
            h = 0;
        }
        else if (max === r && g >= b) {
            h = 60 * ((g - b) / diff);
        }
        else if (max === r && g < b) {
            h = 60 * ((g - b) / diff) + 360;
        }
        else if (max === g) {
            h = 60 * ((b - r) / diff) + 120;
        }
        else if (max === b) {
            h = 60 * ((r - g) / diff) + 240;
        }
        return [Math.round(h), Math.round(s * 100), Math.round(v * 100)];
    };
    __decorate([
        property(cc.Sprite)
    ], Palette.prototype, "hueSprite", void 0);
    __decorate([
        property(cc.Node)
    ], Palette.prototype, "huePointNode", void 0);
    __decorate([
        property(cc.Sprite)
    ], Palette.prototype, "colorBoardSprite", void 0);
    __decorate([
        property(cc.Node)
    ], Palette.prototype, "circleNode", void 0);
    __decorate([
        property(cc.Slider)
    ], Palette.prototype, "rSlider", void 0);
    __decorate([
        property(cc.EditBox)
    ], Palette.prototype, "rEditBox", void 0);
    __decorate([
        property(cc.Slider)
    ], Palette.prototype, "gSlider", void 0);
    __decorate([
        property(cc.EditBox)
    ], Palette.prototype, "gEditBox", void 0);
    __decorate([
        property(cc.Slider)
    ], Palette.prototype, "bSlider", void 0);
    __decorate([
        property(cc.EditBox)
    ], Palette.prototype, "bEditBox", void 0);
    Palette = __decorate([
        ccclass
    ], Palette);
    return Palette;
}(cc.Component));
exports.default = Palette;

cc._RF.pop();