const {ccclass, property} = cc._decorator;

@ccclass
export default class scene extends cc.Component {
    @property(cc.Camera)
    camera: cc.Camera = null;

    @property(cc.Node)
    roleNode: cc.Node = null;

    @property(cc.TiledMap)
    map: cc.TiledMap = null;

    onLoad(){
        let floorLayer = this.map.getLayer(`floor`);
        floorLayer.addUserNode(this.roleNode);
    }

    update(){
        this.camera.node.setPosition(this.roleNode.position);
        this.roleNode.x += 2;
    }
}
