const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    @property(cc.Node)
    imageNode: cc.Node = null;

    start() {
        setTimeout(() => {
            let capturedNode = this.capture(this.imageNode, this.imageNode.getBoundingBoxToWorld());
            capturedNode.x = this.imageNode.x + this.imageNode.width * 1.3;
            capturedNode.y = this.imageNode.y;
            capturedNode.scaleY = -1;
            cc.find("Canvas").addChild(capturedNode);
        }, 10);
    }

    capture(captureNode: cc.Node, cameraRect: cc.Rect): cc.Node {
        let cameraNode = new cc.Node();
        captureNode.addChild(cameraNode);
        let captureCamera = cameraNode.addComponent(cc.Camera);

        // 调整camera位置到captureNode中心
        let localPos = captureNode.convertToNodeSpaceAR(cc.v2(cameraRect.x + cameraRect.width / 2, cameraRect.y + cameraRect.height / 2));
        cameraNode.x = localPos.x;
        cameraNode.y = localPos.y;

        // 初始化renderTexture size
        let renderTexture = new cc.RenderTexture();
        let gl = cc.game['_renderContext'];
        (renderTexture as any).initWithSize(cameraRect.width, cameraRect.height, gl.STENCIL_INDEX8);
        // 渲染图片
        captureCamera.targetTexture = renderTexture;
        captureCamera.render(captureNode);
        cameraNode.destroy();

        let spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(renderTexture);

        let node = new cc.Node();
        let sprite = node.addComponent(cc.Sprite);
        sprite.spriteFrame = spriteFrame;
        return node;
    }
}
