(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/capture.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '17dc1rYyrVIfr0hHaeX8DrV', 'capture', __filename);
// capture.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.imageNode = null;
        return _this;
    }
    NewClass.prototype.start = function () {
        var _this = this;
        setTimeout(function () {
            var capturedNode = _this.capture(_this.imageNode, _this.imageNode.getBoundingBoxToWorld());
            capturedNode.x = _this.imageNode.x + _this.imageNode.width * 1.3;
            capturedNode.y = _this.imageNode.y;
            capturedNode.scaleY = -1;
            cc.find("Canvas").addChild(capturedNode);
        }, 10);
    };
    NewClass.prototype.capture = function (captureNode, cameraRect) {
        var cameraNode = new cc.Node();
        captureNode.addChild(cameraNode);
        var captureCamera = cameraNode.addComponent(cc.Camera);
        // 调整camera位置到captureNode中心
        var localPos = captureNode.convertToNodeSpaceAR(cc.v2(cameraRect.x + cameraRect.width / 2, cameraRect.y + cameraRect.height / 2));
        cameraNode.x = localPos.x;
        cameraNode.y = localPos.y;
        // 初始化renderTexture size
        var renderTexture = new cc.RenderTexture();
        var gl = cc.game['_renderContext'];
        renderTexture.initWithSize(cameraRect.width, cameraRect.height, gl.STENCIL_INDEX8);
        // 渲染图片
        captureCamera.targetTexture = renderTexture;
        captureCamera.render(captureNode);
        cameraNode.destroy();
        var spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(renderTexture);
        var node = new cc.Node();
        var sprite = node.addComponent(cc.Sprite);
        sprite.spriteFrame = spriteFrame;
        return node;
    };
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "imageNode", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=capture.js.map
        