
const {ccclass, property} = cc._decorator;

@ccclass
export default class Main extends cc.Component {

    @property(cc.Prefab)
    preKnife: cc.Prefab = null;
    @property(cc.Node)
    lead:cc.Node = null;

    lastPos=null;
    rate = 5;
    speed = null;
    // onLoad () {}
    start () {
        let self = this;

        //开启碰撞检测
        cc.director.getCollisionManager().enabled = true;
        //开启触摸
        this.node.on(cc.Node.EventType.TOUCH_START, function (event) {
            //console.log('TOUCH_START');
            self.lastPos = event.touch.getLocation();
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
            let pos = event.touch.getLocation();
            //console.log('TOUCH_MOVE',pos);
            //ratio = 4/3;
            self.speed = self.getSpeed(pos);
            self.lastPos = pos;
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_END, function (event) {
            //console.log('TOUCH_END');
            self.speed = null;
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
            //console.log('TOUCH_CANCEL');
            self.speed = null;
        }, this);




        //系统发射刀剑
        let id = setInterval(function(){
            self.systemNewKnife();
        },5000)
    }
    update (dt) {
        if(this.speed)
            this.lead.setPosition(this.lead.x+this.speed.x,this.lead.y+this.speed.y);
    }

    systemNewKnife(){
        let knife = cc.instantiate(this.preKnife);
        this.node.addChild(knife);
        let x = Math.random()*750-375;
        //console.log(x);
        knife.setPosition(cc.v2(x,800));

        let move = cc.moveBy(10,cc.v2(0,-1334));
        let callFunc = cc.callFunc(function(){
            knife.removeFromParent();
        });
        let seq = cc.sequence(move,callFunc);

        knife.runAction(seq);
    }


    //辅助函数
    getSpeed(pos){
        let distanceX = pos.x-this.lastPos.x;
        let distanceY = pos.y-this.lastPos.y;
        let ratio = distanceX/distanceY;
        let x = Math.sqrt(Math.pow(this.rate,2)/(Math.pow(ratio,2)+1));
        let y = x/ratio;
        x *= distanceX>=0?1:-1;
        y *= distanceY>=0?1:-1;
        console.log(distanceX,distanceY,ratio,x,y);
        return cc.v2(x,y);
    }
}