(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/main.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '6e5acwWMUpJdZxZRLAjjMlI', 'main', __filename);
// Script/main.ts

Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Main = /** @class */ (function (_super) {
    __extends(Main, _super);
    function Main() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.preKnife = null;
        _this.lead = null;
        _this.lastPos = null;
        _this.rate = 5;
        _this.speed = null;
        return _this;
    }
    // onLoad () {}
    Main.prototype.start = function () {
        var self = this;
        //开启碰撞检测
        cc.director.getCollisionManager().enabled = true;
        //开启触摸
        this.node.on(cc.Node.EventType.TOUCH_START, function (event) {
            //console.log('TOUCH_START');
            self.lastPos = event.touch.getLocation();
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
            var pos = event.touch.getLocation();
            //console.log('TOUCH_MOVE',pos);
            //ratio = 4/3;
            self.speed = self.getSpeed(pos);
            self.lastPos = pos;
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_END, function (event) {
            //console.log('TOUCH_END');
            self.speed = null;
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, function (event) {
            //console.log('TOUCH_CANCEL');
            self.speed = null;
        }, this);
        //系统发射刀剑
        var id = setInterval(function () {
            self.systemNewKnife();
        }, 5000);
    };
    Main.prototype.update = function (dt) {
        if (this.speed)
            this.lead.setPosition(this.lead.x + this.speed.x, this.lead.y + this.speed.y);
    };
    Main.prototype.systemNewKnife = function () {
        var knife = cc.instantiate(this.preKnife);
        this.node.addChild(knife);
        var x = Math.random() * 750 - 375;
        //console.log(x);
        knife.setPosition(cc.v2(x, 800));
        var move = cc.moveBy(10, cc.v2(0, -1334));
        var callFunc = cc.callFunc(function () {
            knife.removeFromParent();
        });
        var seq = cc.sequence(move, callFunc);
        knife.runAction(seq);
    };
    //辅助函数
    Main.prototype.getSpeed = function (pos) {
        var distanceX = pos.x - this.lastPos.x;
        var distanceY = pos.y - this.lastPos.y;
        var ratio = distanceX / distanceY;
        var x = Math.sqrt(Math.pow(this.rate, 2) / (Math.pow(ratio, 2) + 1));
        var y = x / ratio;
        x *= distanceX >= 0 ? 1 : -1;
        y *= distanceY >= 0 ? 1 : -1;
        console.log(distanceX, distanceY, ratio, x, y);
        return cc.v2(x, y);
    };
    __decorate([
        property(cc.Prefab)
    ], Main.prototype, "preKnife", void 0);
    __decorate([
        property(cc.Node)
    ], Main.prototype, "lead", void 0);
    Main = __decorate([
        ccclass
    ], Main);
    return Main;
}(cc.Component));
exports.default = Main;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=main.js.map
        