// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.RichText)
    label: cc.RichText = null;

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.label.string = "";
    }

    start() {

        this.fixFrameView();

        this.schedule(this.showLocalLanguage.bind(this), 1);
    }

    PrefixInteger(num, m) : string {
        return (Array(m).join("0") + num).slice(-m);
    }
    showLocalLanguage() {
        var date: Date = new Date(cc.sys.now());

        var str =`${date.getFullYear()}年${this.PrefixInteger(date.getMonth() + 1, 2)}月${this.PrefixInteger(date.getDate(), 2)}日 ${this.PrefixInteger(date.getHours(), 2)}:${this.PrefixInteger(date.getMinutes(), 2)}:${this.PrefixInteger(date.getSeconds(), 2)}`
        str += "\n";

        str += `\n网络类型 = <color=#00ff00 >${ cc.sys.getNetworkType() }</c>`;
        str += `\n电量 = <color=#00ff00 >${ cc.sys.getBatteryLevel() * 100 }%</c>`;

        str += "\n";

        str += `\nplatform = <color=#00ff00 >${ cc.sys.platform}</c>`;
        str += `\nisMobile = <color=#00ff00 >${ cc.sys.isMobile}</c>`;
        str += `\nisBrowser = <color=#00ff00 >${ cc.sys.isBrowser}</c>`;
        str += `\nisNative = <color=#00ff00 >${ cc.sys.isNative }</c>`;

        str += "\n";

        str += `\nos = <color=#00ff00 >${ cc.sys.os}</c>`;
        str += `\nosVersion = <color=#00ff00 >${ cc.sys.osVersion}</c>`;
        str += `\nosMainVersion = <color=#00ff00 >${ cc.sys.osMainVersion}</c>`;
        str += `\nbrowserType = <color=#00ff00 >${ cc.sys.browserType}</c>`;
        str += `\nbrowserVersion = <color=#00ff00 >${ cc.sys.browserVersion}</c>`;

        str += "\n";

        str += `\nlanguage = <color=#00ff00 >${ cc.sys.language }</c>`;
        str += `\nlanguage code = <color=#00ff00 >${ cc.sys.languageCode }</c>`;
        str += "\n";

        str += `\ncc.sys.LANGUAGE_ENGLISH = <color=#00ff00 >${ cc.sys.LANGUAGE_ENGLISH }</c>`;
        str += `\ncc.sys.LANGUAGE_CHINESE = <color=#00ff00 >${ cc.sys.LANGUAGE_CHINESE }</c>`;
        str += `\ncc.sys.LANGUAGE_FRENCH = <color=#00ff00 >${ cc.sys.LANGUAGE_FRENCH }</c>`;
        str += `\ncc.sys.LANGUAGE_ITALIAN = <color=#00ff00 >${ cc.sys.LANGUAGE_ITALIAN }</c>`;
        str += `\ncc.sys.LANGUAGE_GERMAN = <color=#00ff00 >${ cc.sys.LANGUAGE_GERMAN }</c>`;
        str += `\ncc.sys.LANGUAGE_SPANISH = <color=#00ff00 >${ cc.sys.LANGUAGE_SPANISH }</c>`;
        str += `\ncc.sys.LANGUAGE_DUTCH = <color=#00ff00 >${ cc.sys.LANGUAGE_DUTCH }</c>`;
        str += `\ncc.sys.LANGUAGE_RUSSIAN = <color=#00ff00 >${ cc.sys.LANGUAGE_RUSSIAN }</c>`;
        str += `\ncc.sys.LANGUAGE_KOREAN = <color=#00ff00 >${ cc.sys.LANGUAGE_KOREAN }</c>`;
        str += `\ncc.sys.LANGUAGE_JAPANESE = <color=#00ff00 >${ cc.sys.LANGUAGE_JAPANESE }</c>`;
        str += `\ncc.sys.LANGUAGE_HUNGARIAN = <color=#00ff00 >${ cc.sys.LANGUAGE_HUNGARIAN }</c>`;
        str += `\ncc.sys.LANGUAGE_PORTUGUESE = <color=#00ff00 >${ cc.sys.LANGUAGE_PORTUGUESE }</c>`;
        str += `\ncc.sys.LANGUAGE_ARABIC = <color=#00ff00 >${ cc.sys.LANGUAGE_ARABIC }</c>`;
        str += `\ncc.sys.LANGUAGE_NORWEGIAN = <color=#00ff00 >${ cc.sys.LANGUAGE_NORWEGIAN }</c>`;
        str += `\ncc.sys.LANGUAGE_POLISH = <color=#00ff00 >${ cc.sys.LANGUAGE_POLISH }</c>`;
        str += `\ncc.sys.LANGUAGE_TURKISH = <color=#00ff00 >${ cc.sys.LANGUAGE_TURKISH }</c>`;
        str += `\ncc.sys.LANGUAGE_ROMANIAN = <color=#00ff00 >${ cc.sys.LANGUAGE_ROMANIAN }</c>`;
        str += `\ncc.sys.LANGUAGE_BULGARIAN = <color=#00ff00 >${ cc.sys.LANGUAGE_BULGARIAN }</c>`;
        str += `\ncc.sys.LANGUAGE_UNKNOWN = <color=#00ff00 >${ cc.sys.LANGUAGE_UNKNOWN }</c>`;

        this.label.string = str;
    }



     //适配窗口
     fixFrameView() {

        var screenSize = cc.view.getCanvasSize();
        var frameSize = cc.view.getFrameSize();
        var oldFrameSize = cc.view.getFrameSize();
        var scale = frameSize.width / screenSize.width;
        scale = Math.min(scale, 1);
        frameSize.width *= scale;
        frameSize.height *= scale;
        cc.view.resizeWithBrowserSize(true);
        cc.view.setFrameSize(frameSize.width, frameSize.height);
    }

}
