// Learn cc.Class:
//  - [Chinese] http://www.cocos.com/docs/creator/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/editors_and_tools/creator-chapters/scripting/class/index.html
// Learn Attribute:
//  - [Chinese] http://www.cocos.com/docs/creator/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/editors_and_tools/creator-chapters/scripting/reference/attributes/index.html
// Learn life-cycle callbacks:
//  - [Chinese] http://www.cocos.com/docs/creator/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/editors_and_tools/creator-chapters/scripting/life-cycle-callbacks/index.html

import BaseComponent from "./BaseComponent";

cc.Class({
    extends: BaseComponent,

    properties: {
        live2dModel:cc.RawAsset,
    },

    ctor: function() {
        this.x = 0;
        this.y = 0;
        this.scaleX = 1;
        this.scaleY = 1;
        this.rotation = 0;
        var t = this._sgNode = this._createSgNode();
        if (t) {
            t.retain();
            t.setVisible(!1);
        }
    },

    __preload: function() {
        this._initSgNode();
        this._appendSgNode(this._sgNode);
    },

    onEnable: function() {
        this._sgNode && this._sgNode.setVisible(!0);
    },

    onDisable: function() {
        this._sgNode && this._sgNode.setVisible(!1);
    },

    onDestroy: function() {
        this.node._sizeProvider === this._sgNode && (this.node._sizeProvider = null);
        var sgNode = this._sgNode;
        if (sgNode) {
            var parent = sgNode._parent;
            if (parent) {
                parent.removeChild(sgNode);
            }
            else {
                sgNode.cleanup();
            }
            if (sgNode._entity) {
                sgNode._entity = null;
            }
        }
    },

    _createSgNode: function (){
        if(!cc.LAppView){
            return null;
        }
        return new cc.LAppView();
    },

    _initSgNode: function() {
        var t = this._sgNode;
        if (t) {
            this.enabledInHierarchy || t.setVisible(!1);
            var e = this.node;
            t.setAnchorPoint(e.getAnchorPoint());
            this.setModel(this.live2dModel);
        }
    },

    _appendSgNode: function(t) {
        if (t) {
            var e = this.node;
            t.setColor(e._color);
            e._cascadeOpacityEnabled || t.setOpacity(e._opacity);
            t.setAnchorPoint(e._anchorPoint);
            t.setOpacityModifyRGB(e._opacityModifyRGB);
            t.setLocalZOrder(-1);
            e._sgNode.addChild(t);
        }
    },

    setModel: function (rawUrl) {
        var sgNode = this._sgNode;
        if (sgNode) {
            this._sgNode.setModel(cc.path.dirname(rawUrl), cc.path.basename(rawUrl));
        }
    },

    touchBegin: function (touchPos){
        var sgNode = this._sgNode;
        if (sgNode) {
            sgNode.touchBegan(touchPos);
        }
    },

    touchMove: function (touchPos){
        var sgNode = this._sgNode;
        if (sgNode) {
            sgNode.touchMoved(touchPos);
        }
    },

    touchEnd: function (touchPos){
        var sgNode = this._sgNode;
        if (sgNode) {
            sgNode.touchEnded(touchPos);
        }
    },

    playAnim: function (name, index, priority) {
        var sgNode = this._sgNode;
        if (sgNode && sgNode.StartMotion) {
            sgNode.StartMotion(name, index, priority);
        }
    },

    playRandomAnim: function (name, priority) {
        var sgNode = this._sgNode;
        if (sgNode && sgNode.StartRandomMotion) {
            sgNode.StartRandomMotion(name, priority);
        }
    },
});
