"use strict";
cc._RF.push(module, '0486fOqHrJN+6c5PQg5FHh9', 'Game');
// scripts/Game.js

"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _class, _desc, _value, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11, _descriptor12, _descriptor13;

var _Player = require("./Player");

var _Player2 = _interopRequireDefault(_Player);

var _ScoreFX = require("./ScoreFX");

var _ScoreFX2 = _interopRequireDefault(_ScoreFX);

var _Star = require("./Star");

var _Star2 = _interopRequireDefault(_Star);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _initDefineProp(target, property, descriptor, context) {
    if (!descriptor) return;
    Object.defineProperty(target, property, {
        enumerable: descriptor.enumerable,
        configurable: descriptor.configurable,
        writable: descriptor.writable,
        value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
    });
}

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
    var desc = {};
    Object['ke' + 'ys'](descriptor).forEach(function (key) {
        desc[key] = descriptor[key];
    });
    desc.enumerable = !!desc.enumerable;
    desc.configurable = !!desc.configurable;

    if ('value' in desc || desc.initializer) {
        desc.writable = true;
    }

    desc = decorators.slice().reverse().reduce(function (desc, decorator) {
        return decorator(target, property, desc) || desc;
    }, desc);

    if (context && desc.initializer !== void 0) {
        desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
        desc.initializer = undefined;
    }

    if (desc.initializer === void 0) {
        Object['define' + 'Property'](target, property, desc);
        desc = null;
    }

    return desc;
}

function _initializerWarningHelper(descriptor, context) {
    throw new Error('Decorating class property failed. Please ensure that transform-class-properties is enabled.');
}

var _cc$_decorator = cc._decorator,
    ccclass = _cc$_decorator.ccclass,
    property = _cc$_decorator.property;
var NewScript = (_dec = property(cc.Prefab), _dec2 = property(cc.Prefab), _dec3 = property(cc.Node), _dec4 = property(_Player2.default), _dec5 = property(cc.Label), _dec6 = property(cc.AudioClip), _dec7 = property(cc.Node), _dec8 = property(cc.Node), _dec9 = property(cc.Label), _dec10 = property({
    multiline: true
}), _dec11 = property({
    multiline: true
}), ccclass(_class = (_class2 = function (_cc$Component) {
    _inherits(NewScript, _cc$Component);

    function NewScript() {
        var _ref;

        var _temp, _this, _ret;

        _classCallCheck(this, NewScript);

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = NewScript.__proto__ || Object.getPrototypeOf(NewScript)).call.apply(_ref, [this].concat(args))), _this), _initDefineProp(_this, "starPrefab", _descriptor, _this), _initDefineProp(_this, "scoreFXPrefab", _descriptor2, _this), _initDefineProp(_this, "maxStarDuration", _descriptor3, _this), _initDefineProp(_this, "minStarDuration", _descriptor4, _this), _initDefineProp(_this, "ground", _descriptor5, _this), _initDefineProp(_this, "player", _descriptor6, _this), _initDefineProp(_this, "scoreDisplay", _descriptor7, _this), _initDefineProp(_this, "scoreAudio", _descriptor8, _this), _initDefineProp(_this, "btnNode", _descriptor9, _this), _initDefineProp(_this, "gameOverNode", _descriptor10, _this), _initDefineProp(_this, "controlHintLabel", _descriptor11, _this), _initDefineProp(_this, "keyboardHint", _descriptor12, _this), _initDefineProp(_this, "touchHint", _descriptor13, _this), _temp), _possibleConstructorReturn(_this, _ret);
    }

    /**
     * @type {cc.Prefab}
     */


    // 星星产生后消失时间的随机范围


    // 地面节点，用于确定星星生成的高度


    // player 节点，用于获取主角弹跳的高度，和控制主角行动开关
    /**
     * @type {Player}
     */


    // score label 的引用


    // 得分音效资源


    _createClass(NewScript, [{
        key: "onLoad",


        // use this for initialization
        value: function onLoad() {
            // 获取地平面的 y 轴坐标
            this.groundY = this.ground.y + this.ground.height / 2;

            // store last star's x position
            this.currentStar = null;
            this.currentStarX = 0;

            // 初始化计时器
            this.timer = 0;
            this.starDuration = 0;

            // is showing menu or running game
            this.isRunning = false;

            // initialize control hint
            var hintText = cc.sys.isMobile ? this.touchHint : this.keyboardHint;
            this.controlHintLabel.string = hintText;

            // initialize star and score pool
            this.starPool = new cc.NodePool('Star');
            this.scorePool = new cc.NodePool('ScoreFX');
        }
    }, {
        key: "onStartGame",
        value: function onStartGame() {
            // 初始化计分
            this.resetScore();
            // set game state to running
            this.isRunning = true;
            // set button and gameover text out of screen
            this.btnNode.setPositionX(3000);
            this.gameOverNode.active = false;
            // reset player position and move speed
            this.player.startMoveAt(cc.p(0, this.groundY));
            // spawn star
            this.spawnNewStar();
        }
    }, {
        key: "spawnNewStar",
        value: function spawnNewStar() {
            /**
             * @type {cc.Node}
             */
            var newStar = null;
            // 使用给定的模板在场景中生成一个新节点
            if (this.starPool.size() > 0) {
                newStar = this.starPool.get(this); // this will be passed to Star's reuse method
            } else {
                newStar = cc.instantiate(this.starPrefab);
            }
            // 将新增的节点添加到 Canvas 节点下面
            this.node.addChild(newStar);
            // 为星星设置一个随机位置
            newStar.setPosition(this.getNewStarPosition());
            // pass Game instance to star
            newStar.getComponent(_Star2.default).init(this);
            // start star timer and store star reference
            this.startTimer();
            this.currentStar = newStar;
        }
    }, {
        key: "despawnStar",
        value: function despawnStar(star) {
            this.starPool.put(star);
            this.spawnNewStar();
        }
    }, {
        key: "startTimer",
        value: function startTimer() {
            // get a life duration for next star
            this.starDuration = this.minStarDuration + cc.random0To1() * (this.maxStarDuration - this.minStarDuration);
            this.timer = 0;
        }
    }, {
        key: "getNewStarPosition",
        value: function getNewStarPosition() {
            // if there's no star, set a random x pos
            if (!this.currentStar) {
                this.currentStarX = cc.randomMinus1To1() * this.node.width / 2;
            }
            var randX = 0;
            // 根据地平面位置和主角跳跃高度，随机得到一个星星的 y 坐标
            var randY = this.groundY + cc.random0To1() * this.player.jumpHeight + 50;
            // 根据屏幕宽度和上一个星星的 x 坐标，随机得到一个新生成星星 x 坐标
            var maxX = this.node.width / 2;
            if (this.currentStarX >= 0) {
                randX = -cc.random0To1() * maxX;
            } else {
                randX = cc.random0To1() * maxX;
            }
            this.currentStarX = randX;
            // 返回星星坐标
            return cc.p(randX, randY);
        }
    }, {
        key: "gainScore",
        value: function gainScore(pos) {
            this.score += 1;
            // 更新 scoreDisplay Label 的文字
            this.scoreDisplay.string = 'Score: ' + this.score.toString();
            // 播放特效
            var fx = this.spawnScoreFX();
            this.node.addChild(fx.node);
            fx.node.setPosition(pos);
            fx.play();
            // 播放得分音效
            cc.audioEngine.playEffect(this.scoreAudio, false);
        }
    }, {
        key: "resetScore",
        value: function resetScore() {
            this.score = 0;
            this.scoreDisplay.string = 'Score: ' + this.score.toString();
        }
    }, {
        key: "spawnScoreFX",
        value: function spawnScoreFX() {
            var fx;
            if (this.scorePool.size() > 0) {
                fx = this.scorePool.get();
                return fx.getComponent(_ScoreFX2.default);
            } else {
                fx = cc.instantiate(this.scoreFXPrefab).getComponent(_ScoreFX2.default);
                fx.init(this);
                return fx;
            }
        }
    }, {
        key: "despawnScoreFX",
        value: function despawnScoreFX(scoreFX) {
            this.scorePool.put(scoreFX);
        }

        // called every frame

    }, {
        key: "update",
        value: function update(dt) {
            if (!this.isRunning) return;
            // 每帧更新计时器，超过限度还没有生成新的星星
            // 就会调用游戏失败逻辑
            if (this.timer > this.starDuration) {
                this.gameOver();
                return;
            }
            this.timer += dt;
        }
    }, {
        key: "gameOver",
        value: function gameOver() {
            this.gameOverNode.active = true;
            this.player.enabled = false;
            this.player.stopMove();
            this.currentStar.destroy();
            this.isRunning = false;
            this.btnNode.setPositionX(0);
        }
    }]);

    return NewScript;
}(cc.Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "starPrefab", [_dec], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "scoreFXPrefab", [_dec2], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "maxStarDuration", [property], {
    enumerable: true,
    initializer: function initializer() {
        return 0;
    }
}), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "minStarDuration", [property], {
    enumerable: true,
    initializer: function initializer() {
        return 0;
    }
}), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "ground", [_dec3], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "player", [_dec4], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "scoreDisplay", [_dec5], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "scoreAudio", [_dec6], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "btnNode", [_dec7], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "gameOverNode", [_dec8], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor11 = _applyDecoratedDescriptor(_class2.prototype, "controlHintLabel", [_dec9], {
    enumerable: true,
    initializer: function initializer() {
        return null;
    }
}), _descriptor12 = _applyDecoratedDescriptor(_class2.prototype, "keyboardHint", [_dec10], {
    enumerable: true,
    initializer: function initializer() {
        return '';
    }
}), _descriptor13 = _applyDecoratedDescriptor(_class2.prototype, "touchHint", [_dec11], {
    enumerable: true,
    initializer: function initializer() {
        return '';
    }
})), _class2)) || _class);
exports.default = NewScript;
module.exports = exports["default"];

cc._RF.pop();