cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        labFile : cc.Label,
        labMd5 : cc.Label, 
        // defaults, set visually when attaching this script to the Canvas
    },

    // use this for initialization
    onLoad: function () {
        require('DYCrypto').init();
    },

    // called every frame
    update: function (dt) {

    },

    onClick : function(event){
        var target = event.target;
        // DDLOG(target.name);

        if (target.name == 'TEST_JSC') {
            var url = jsb.fileUtils.getWritablePath() + "Test/test.jsc"; 
            var filePath = url; //jsb.fileUtils.fullPathForFilename(url);
            this.labFile.string = filePath;

            var fileStr = jsb.fileUtils.getStringFromFile(filePath);
            if (!fileStr){
                this.labMd5.string = "empty";    
            }
            else{
                this.labMd5.string = dy.crypto.md5.hex_md5(fileStr);    
            }
        }
        else if (target.name == 'TEST_PNG') {
            var url = jsb.fileUtils.getWritablePath() + "Test/test.png"; 
            var filePath = url; //jsb.fileUtils.fullPathForFilename(url);
            this.labFile.string = filePath;

            var fileStr = jsb.fileUtils.getStringFromFile(filePath);
            if (!fileStr){
                this.labMd5.string = "empty";    
            }
            else{
                this.labMd5.string = dy.crypto.md5.hex_md5(fileStr);    
            }
        }
        else if (target.name == 'TEST_JSON') {
            var url = jsb.fileUtils.getWritablePath() + "Test/test.json"; 
            var filePath = url; //jsb.fileUtils.fullPathForFilename(url);
            this.labFile.string = filePath;

            var fileStr = jsb.fileUtils.getStringFromFile(filePath);
            if (!fileStr){
                this.labMd5.string = "empty";    
            }
            else{
                this.labMd5.string = dy.crypto.md5.hex_md5(fileStr);    
            }
        }
        
    }
});
