import { _decorator, Component, Node, SliderComponent, AudioClip, AudioSourceComponent, LabelComponent, ProgressBarComponent } from "cc";
const { ccclass, property } = _decorator;

@ccclass("AudioController")
export class AudioController extends Component {
    @property({ type: Node })
    public musicScroll: Node = null;
    @property({ type: Node })
    public audioScroll: Node = null;

    // @property({type: [AudioClip]})
    // public clips: AudioClip[] = [];

    // @property({type: AudioSourceComponent})
    // public audioSource: AudioSourceComponent = null;

    // @property({type: LabelComponent})
    // public nameLabel: LabelComponent = null;    

    private musicBar: ProgressBarComponent = null;
    private audioBar: ProgressBarComponent = null;

    onLoad() {
        this.musicBar = this.musicScroll.getChildByName("Handle").getComponent(ProgressBarComponent);
        this.audioBar = this.audioScroll.getChildByName("Handle").getComponent(ProgressBarComponent);
    }

    update() {
        this.musicBar.progress = this.musicScroll.getComponent(SliderComponent).progress;
        this.audioBar.progress = this.audioScroll.getComponent(SliderComponent).progress;
    }

    onVolumeSliderChanged(eventTarget: SliderComponent) {
        // this.audioSource.volume = eventTarget.progress;
    }
}
