import { _decorator, Component, Node, ButtonComponent, math, RigidBodyComponent, SystemEventType, EventType, ModelComponent, Material } from "cc";
const { ccclass, property } = _decorator;

@ccclass("BtnEvent")
export class BtnEvent extends Component {
    @property({ type: Material })
    public purpleMat: Material = null;
    @property({ type: Material })
    public yellowMat: Material = null;


    /**玩家节点 */
    private playerNode: Node = null;
    /**玩家刚体 */
    private rigidBody: RigidBodyComponent = null;
    /**玩家材质 */
    private playerMaterial: ModelComponent = null;
    /**变色按钮 */
    private kawairBtn: ButtonComponent = null;
    /**返回按钮 */
    private backbtn: ButtonComponent = null;

    public static matName = "PurpleCube";

    onLoad() {
        /**获取按钮组件 */
        this.kawairBtn = this.node.getChildByName("KawairBtn").getComponent(ButtonComponent);
        this.backbtn = this.node.getChildByName("BackBtn").getComponent(ButtonComponent);

        /**全局寻找Player节点 */
        this.playerNode = cc.director.getScene().getChildByName('Player');
        /**获取Player刚体组件 */
        this.rigidBody = this.playerNode.getComponent(RigidBodyComponent);
        this.playerMaterial = this.playerNode.getChildByName('Man').getComponent(ModelComponent);
        /**初始化 */
        this.playerNode.getChildByName("purpleSmoke").active = true;
        this.playerNode.getChildByName("yellowSmoke").active = false;
        BtnEvent.matName = "PurpleCube";

        /**按钮监听 */
        this.kawairBtn.node.on("click", this.kawairMove, this);
        this.backbtn.node.on("click", this.backMove, this);
    }
    public static isone: boolean = true;
    /**变色监听事件 */
    kawairMove() {
        console.log("变色");
        if (BtnEvent.isone) {
            //黄色开启紫色关闭
            BtnEvent.matName = "YellowCube";
            this.playerNode.getChildByName("yellowSmoke").active = true;
            this.playerNode.getChildByName("purpleSmoke").active = false;
            this.playerMaterial.material = this.yellowMat;
            BtnEvent.isone = false;
        } else {
            //紫色开启黄色关闭
            BtnEvent.matName = "PurpleCube";
            this.playerNode.getChildByName("yellowSmoke").active = false;
            this.playerNode.getChildByName("purpleSmoke").active = true;
            this.playerMaterial.material = this.purpleMat;
            BtnEvent.isone = true;
        }

    }
    
    /**返回按钮 */
    backMove(){

    }
  
}
