import { _decorator, Component, Node, UITransformComponent, LabelComponent, RigidBodyComponent } from "cc";
const { ccclass, property } = _decorator;

@ccclass("LongTouchComponent")
export default class LongTouchComponent extends Component {
    /** 触摸计数器*/
    private timer: number = 0;
    private count: number = 30;
    /** 标记当前是否在触摸这个节点*/
    private playerNode: Node = null;
    public static _isDoubleJump: boolean = false;
    public static _isTouching: boolean = false;

    private rigidBody: RigidBodyComponent = null;
    onLoad() {
        /**全局寻找Player节点 */
        this.playerNode = cc.director.getScene().getChildByName('Player');
        /**获取Player刚体组件 */
        this.rigidBody = this.playerNode.getComponent(RigidBodyComponent);
    }

    /**激活 */
    onEnable() {
        this.node.on(cc.SystemEvent.EventType.TOUCH_START, this._onTouchStart, this);
        this.node.on(cc.SystemEvent.EventType.TOUCH_END, this._onTouchEnd, this);
        this.node.on(cc.SystemEvent.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
    }

    onDisable() {
        this.node.on(cc.SystemEvent.EventType.TOUCH_START, this._onTouchStart, this);
        this.node.on(cc.SystemEvent.EventType.TOUCH_END, this._onTouchEnd, this);
        this.node.on(cc.SystemEvent.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
    }

    /**进入 */
    private _onTouchStart(event) {
        console.log("触摸进入");
        //开始一个计时器
        if (LongTouchComponent._isTouching) {
            this.schedule(this._touchCounterCallback, this.timer);
        } else {
            if (LongTouchComponent._isDoubleJump) {
                return;
            }
            else {
                LongTouchComponent._isDoubleJump = true;
                this.schedule(this._touchCounterCallback, this.timer);
                console.log("两段跳");
            }
        }
    }

    /**离开 */
    private _onTouchEnd(event) {
        this.count = 15;
        this.unschedule(this._touchCounterCallback);
    }

    /**离开  */
    private _onTouchCancel(event) {
        this.count = 15;
        this.unschedule(this._touchCounterCallback);
    }

    /**计时器回调 */
    private _touchCounterCallback() {
        this.count--;
        console.log(this.count);
        if (this.count == 0) {
            // 在第六次执行回调时取消这个计时器
            this.unschedule(this._touchCounterCallback);
        }

        const velocity = new cc.Vec3(0, 20, 0);
        this.rigidBody.setLinearVelocity(velocity);
    }

}
