import { _decorator, Component, Node, ButtonComponent, Vec3, tweenUtil } from "cc";
import { UItool } from "./UITool";
import { UIattribute } from "./UIattribute";
const { ccclass, property } = _decorator;

@ccclass("BtnControl")
export class BtnControl extends Component {
    @property({ type: Node })
    settingPage: Node = null;
    @property({ type: Node })
    gamePage: Node = null;
    @property({ type: Node })
    timePage: Node = null;
    @property({ type: Node })
    playPage: Node = null;

    /**游戏开始组件 */
    private playgameBtn: ButtonComponent = null;
    /**游戏按钮 */
    private gameBtn: ButtonComponent = null;
    /**游戏开始组件 */
    private settingBtn: ButtonComponent = null;
    /**游戏开始组件 */
    private timeBtn: ButtonComponent = null;

    onLoad() {
        /**获取按钮组件 */
        this.playgameBtn = this.node.getChildByName("playGameButton").getComponent(ButtonComponent);
        this.gameBtn = this.node.getChildByName("gameButton").getComponent(ButtonComponent);
        this.settingBtn = this.node.getChildByName("settingButton").getComponent(ButtonComponent);
        this.timeBtn = this.node.getChildByName("timeButton").getComponent(ButtonComponent);
        /**按钮监听 */
        this.playgameBtn.node.on("click", this.playgameMove, this);
        this.gameBtn.node.on("click", this.gameMove, this);
        this.settingBtn.node.on("click", this.settingMove, this);
        this.timeBtn.node.on("click", this.timeMove, this);

    }

    onDisable() {
        /**获取按钮组件 */
        this.playgameBtn = this.node.getChildByName("playGameButton").getComponent(ButtonComponent);
        this.gameBtn = this.node.getChildByName("gameButton").getComponent(ButtonComponent);
        this.settingBtn = this.node.getChildByName("settingButton").getComponent(ButtonComponent);
        this.timeBtn = this.node.getChildByName("timeButton").getComponent(ButtonComponent);
        /**按钮监听 */
        this.playgameBtn.node.on("click", this.playgameMove, this);
        this.gameBtn.node.on("click", this.gameMove, this);
        this.settingBtn.node.on("click", this.settingMove, this);
        this.timeBtn.node.on("click", this.timeMove, this);
    }


    playgameMove() {
        console.log("游戏开始");
        this.playPage.active=true;
        this.node.active = false;        
    }

    gameMove() {
        console.log("打开游戏界面");
    }

    settingMove() {
        this.settingPage.active = true;
        this.node.active = false;
    }

    timeMove() {
        console.log("打开记录界面");
    }


}
