import { Vec3, tweenUtil, TweenEasing } from "cc";

class UITool {
    /**
     * pos 目标坐标
     * NodePos 节点坐标
     * time  缓动时间
     * repos 缓动属性
     * easstr 缓动方式
     */
    tweenFun(pos:Vec3,NodePos:Vec3,time:number,repos:Vec3,easstr:TweenEasing){
        Vec3.copy(pos, NodePos);

        tweenUtil(pos)
            .to(time, repos, { easing: easstr })
            .union()
            .start();
    }

}
export const UItool = new UITool();