import { _decorator, Component, Node, PageViewComponent, Vec3, Prefab, PageViewIndicatorComponent, SpriteComponent, ButtonComponent } from "cc";
const { ccclass, property } = _decorator;

@ccclass("playPageView")
export class playPageView extends Component {
    private _pageview: PageViewComponent = null;
    private _pageChildren: any = null;

    onLoad() {
        this._pageview = this.node.getComponent(PageViewComponent);
        this._pageChildren = this.node.getChildByName("view").getChildByName("content").children;
        this.node.on(cc.SystemEvent.EventType.TOUCH_END, this._onTouchEnd, this);
        this.node.on(cc.SystemEvent.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.Scale();


    }

    _onTouchEnd() {
        this.Scale();//到时候滑动完就给回调
    }

    _onTouchCancel() {
        this.Scale();//到时候滑动完就给回调
    }

    //当前页缩放
    Scale() {
        var scaleNode = this._pageChildren[this.CurrnetPageNum()];
        // scaleNode.getComponent(SpriteComponent).priority = 1;
        scaleNode.setScale(1.2, 1.2, 1.2);
        for (let index = 0; index < this._pageChildren.length; index++) {
            if (index == this.CurrnetPageNum()) {
                continue;
            }
            var elseNode = this._pageChildren[index];
            elseNode.setScale(1, 1, 1);
            // elseNode.getComponent(SpriteComponent).priority =0;
            console.log(index)
        }
    }


    CurrnetPageNum() {
        //当前页
        var c_page = this._pageview.getCurrentPageIndex();
        return c_page;
    }
}   
