"use strict";

System.register(["cc", "./BtnEvent.ts", "./LongTouchComponent.ts"], function (_export, _context) {
  "use strict";

  var _decorator, Component, RigidBodyComponent, Vec3, math, ModelComponent, ColliderComponent, Material, BtnEvent, LongTouchComponent, _dec, _dec2, _dec3, _class, _class2, _descriptor, _temp, menu, ccclass, property, PlayerCon;

  _export({
    _dec: void 0,
    _dec2: void 0,
    _dec3: void 0,
    _class: void 0,
    _class2: void 0,
    _descriptor: void 0,
    _temp: void 0
  });

  return {
    setters: [function (_cc) {
      _decorator = _cc._decorator;
      Component = _cc.Component;
      RigidBodyComponent = _cc.RigidBodyComponent;
      Vec3 = _cc.Vec3;
      math = _cc.math;
      ModelComponent = _cc.ModelComponent;
      ColliderComponent = _cc.ColliderComponent;
      Material = _cc.Material;
    }, function (_BtnEventTs) {
      BtnEvent = _BtnEventTs.BtnEvent;
    }, function (_LongTouchComponentTs) {
      LongTouchComponent = _LongTouchComponentTs.default;
    }],
    execute: function () {
      cc._RF.push(window.module || {}, "3b777YrlrxANL6Bugl68Bsf", "PlayerCon"); // begin PlayerCon


      menu = _decorator.menu;
      ccclass = _decorator.ccclass;
      property = _decorator.property;

      _export("PlayerCon", PlayerCon = (_dec = ccclass("PlayerCon"), _dec2 = menu("physics/PlayerCon"), _dec3 = property({
        type: Material
      }), _dec(_class = _dec2(_class = (_class2 = (_temp =
      /*#__PURE__*/
      function (_Component) {
        babelHelpers.inherits(PlayerCon, _Component);

        function PlayerCon() {
          var _babelHelpers$getProt;

          var _this;

          babelHelpers.classCallCheck(this, PlayerCon);

          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          _this = babelHelpers.possibleConstructorReturn(this, (_babelHelpers$getProt = babelHelpers.getPrototypeOf(PlayerCon)).call.apply(_babelHelpers$getProt, [this].concat(args)));
          babelHelpers.initializerDefineProperty(_this, "purpleMat", _descriptor, babelHelpers.assertThisInitialized(_this));
          _this.rigidbody = null;
          _this.speed = 20;
          _this.startPos = null;
          _this.gameOver = false;
          return _this;
        }

        babelHelpers.createClass(PlayerCon, [{
          key: "onLoad",
          value: function onLoad() {
            this.rigidbody = this.node.getComponent(RigidBodyComponent);
            this.startPos = this.node.getPosition();
            this.playerMaterial = this.node.getChildByName('Man').getComponent(ModelComponent);
          }
        }, {
          key: "start",
          value: function start() {
            var Collider = this.getComponent(ColliderComponent);
            Collider.on('onCollisionStay', this.onCollision, this);
            this.gameOver = true;
          }
        }, {
          key: "update",
          value: function update(dt) {
            if (this.gameOver) {
              var position = this.node.getPosition();
              math.Vec3.scaleAndAdd(position, position, this.getDirection(0, 0, -1), dt * 30);
              this.node.setPosition(position);
            } else {
              this.gameInit();
              this.gameOver = true;
            }
          }
        }, {
          key: "gameInit",
          value: function gameInit() {
            this.node.setPosition(this.startPos);
            BtnEvent.matName = "PurpleCube";
            BtnEvent.isone = true;
            this.playerMaterial.material = this.purpleMat;
            this.node.getChildByName('purpleSmoke').active = true;
            this.node.getChildByName('yellowSmoke').active = false;
          }
        }, {
          key: "onCollision",
          value: function onCollision(event) {
            /**如果按了不能再按 */
            LongTouchComponent._isTouching = false;
            LongTouchComponent._isDoubleJump = false;
            /**判断碰到的颜色是否一致 */

            if (event.otherCollider.node.name != BtnEvent.matName) {
              this.gameOver = false;
              console.log(this.node.getPosition());
            }
          }
        }, {
          key: "getDirection",
          value: function getDirection(x, y, z) {
            var result = new Vec3(x, y, z);
            math.Vec3.transformQuat(result, result, this.node.getRotation());
            return result;
          }
        }]);
        return PlayerCon;
      }(Component), _temp), (_descriptor = babelHelpers.applyDecoratedDescriptor(_class2.prototype, "purpleMat", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class) || _class));

      cc._RF.pop(); // end PlayerCon

    }
  };
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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