
const { ccclass, property } = cc._decorator;

@ccclass
export default class PlayMusic extends cc.Component {

    private musicId: number;
    private url = "https://misc-1253235820.cos.ap-chengdu.myqcloud.com/3.mp3"

    protected onLoad() {
        this.playLocalMusic();
    }

    private playRemoteMusic() {
        this.playMusic(this.url);
    }

    private playLocalMusic() {
        wx.downloadFile({
            url: this.url,
            fail: (err) => {
                console.log(err);
            },
            success: (res) => {
                console.log(res);
                this.playMusic(res.tempFilePath);
            }
        });
    }

    private playMusic(url: string) {
        cc.loader.load(url, (err, res) => {
            if (err) {
                console.log(err);
            }
            else {
                console.log("load ok");
                this.musicId = cc.audioEngine.playMusic(res, false);
            }

        })
    }

    update() {
        console.log(cc.audioEngine.getDuration(this.musicId), cc.audioEngine.getCurrentTime(this.musicId));
    }
}