// Learn TypeScript:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class H extends cc.Component {

    // LIFE-CYCLE CALLBACKS:

     onLoad () 
     {
        this.setOrientation("H");
     }

    start () {

    }

    // update (dt) {}

    clickSwitch()
    {
        cc.director.loadScene("V");
    }

    // "V" "H"
    setOrientation(dir)
    {
        cc.director.pause();

        let methodName = "setOrientation";
        if (cc.sys.os == cc.sys.OS_WINDOWS) {
        } else if (cc.sys.os == cc.sys.OS_IOS) {
            methodName = methodName + ":";
            jsb.reflection.callStaticMethod("AppController", methodName, dir);
        } else if (cc.sys.os == cc.sys.OS_ANDROID) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", methodName, "(Ljava/lang/String;)V",dir);
        }

        let canvas = cc.find('Canvas');
        let frameSize = cc.view.getFrameSize();
        console.log("000  frame width : " + frameSize.width);
        console.log("000  frame height : " + frameSize.height);

        if (dir == "V") {//竖屏
            if (frameSize.width > frameSize.height) {
                cc.view.setFrameSize(frameSize.height, frameSize.width);
            }
            canvas.designResolution: cc.size(720, 1280);
            canvas.fitHeight = true;
            canvas.fitWidth = true;
        } else if (dir == "H") {//横屏
            if (frameSize.height > frameSize.width) {
                cc.view.setFrameSize(frameSize.height, frameSize.width);
            }
            canvas.designResolution: cc.size(1280, 720);
            canvas.fitHeight = true;
            canvas.fitWidth = true;
        }

        console.log("111  frame width : " + cc.view.getFrameSize().width);
        console.log("111  frame height : " + cc.view.getFrameSize().height);

        cc.director.resume();
    }

    // "V" "H"
    /*setOrientation(dir)
    {
        cc.director.pause();

        let methodName = "setOrientation";
        if (cc.sys.os == cc.sys.OS_WINDOWS) {
        } else if (cc.sys.os == cc.sys.OS_IOS) {
            methodName = methodName + ":";
            jsb.reflection.callStaticMethod("AppController", methodName, dir);
        } else if (cc.sys.os == cc.sys.OS_ANDROID) {
            jsb.reflection.callStaticMethod("org/cocos2dx/javascript/AppActivity", methodName, "(Ljava/lang/String;)V",dir);
        }

        let frameSize = cc.view.getFrameSize();
        if (dir == "V") {//竖屏
            if (frameSize.width > frameSize.height){
                cc.view.setFrameSize(frameSize.height,frameSize.width);
            }
            cc.view.setDesignResolutionSize(720, 1280, cc.ResolutionPolicy.FIXED_HEIGHT);
        }else if(dir == "H") {//横屏
            if (frameSize.height > frameSize.width){
                cc.view.setFrameSize(frameSize.height,frameSize.width);
            }
            cc.view.setDesignResolutionSize(1280, 720, cc.ResolutionPolicy.FIXED_HEIGHT);
        }
                
        cc.director.resume();
    }*/
}
