cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;
    },

    onEnable: function () {
        this.ws = new WebSocket("ws://10.1.1.90:9345");
        this.ws.binaryType = "arraybuffer";
        this.ws.onopen = (event) => {
            cc.log('ws on open');
        }
        this.ws.onmessage = (event) => {
            cc.log('ws on message');
        }

        this.ws.onerror = (event) => {
            cc.log('ws on error');
            this.ws = null;
        }

        this.ws.onclose = (event) => {
            cc.log("ws on close");
            this.ws = null;
        }
    },

    // called every frame
    update: function (dt) {

    },
});
