const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property(cc.Node)
    test: cc.Node = null;

    start() {
        // init logic
        this.label.string = this.text;
    }

    onClickTest() {
        this.test.removeAllChildren(true);
        // 释放一个 prefab 以及所有它依赖的资源
        var deps = cc.loader.getDependsRecursively('NewDragonTest');
        cc.loader.release(deps);
        this.scheduleOnce(() => {
            cc.sys.garbageCollect();
        }, 0)
    }

    onClickTestAdd() {
        // this.test.destroy();
        // this.scheduleOnce(()=>{
        //     cc.sys.garbageCollect();
        // },0)
        cc.loader.loadRes('NewDragonTest', cc.Prefab, (err, res) => {
            let node: cc.Node = cc.instantiate(res);
            node.parent = this.test;
        })
    }
}
