const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property(cc.Sprite)
    testSp: cc.Sprite = null;

    start () {
        // init logic

        let spf: cc.SpriteFrame = this.testSp.spriteFrame;
        let tex2d: cc.Texture2D = spf.getTexture();
        cc.log('spfRef: ', spf.refCount);  // 1
        cc.log('texRef:', tex2d.refCount);  // 1

        cc.resources.load('textures/test2', cc.SpriteFrame, (err, frame: cc.SpriteFrame)=>{
            if (!err) {
                this.testSp.spriteFrame.decRef(); // 释放原来的纹理
                frame.addRef(); // 引用新纹理
                this.testSp.spriteFrame = frame;

                cc.log('a:', frame.refCount); //  1
                cc.log('b:', frame.getTexture().refCount);  // 1
            }

            
            this.scheduleOnce(t=>{
                cc.log('old spfRef: ', spf.refCount);  // 0
                cc.log('old texRef:', tex2d.refCount);  // 0

                cc.log('new spf:', this.testSp.spriteFrame.refCount);  // 1
                cc.log('new tex2d: ', this.testSp.spriteFrame.getTexture().refCount);  // 0 ?? 为何不是1？
            }, 0);
        });
    }
}
