package org.cocos2dx.javascript.tools;

import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;

import org.cocos2dx.javascript.AppActivity;
import org.cocos2dx.lib.Cocos2dxJavascriptJavaBridge;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;

public class HttpClientUtil {

    public   static String currentHttpImgResPath = "http://source.gayxht.com:7676/upload/img";
    public  static String currentHttpAudioResPath = "http://source.gayxht.com:7676/upload/audio";

    public static void upLoadHeadFilePost(String path, Uri headUri)  {
        System.out.println("请求："+path);
        String ret ="";

        String end = "\r\n";
        String twoHyphens = "--";
        String boundary = "---------------------------823928434";
        try {
            URL url = new URL(path);
            HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);


            DataOutputStream dos = new DataOutputStream(httpURLConnection.getOutputStream());
            dos.writeBytes(twoHyphens + boundary + end);
            dos.writeBytes("Content-Disposition: form-data; type=\"file\"; filename=\"test.png\";name=\"imgFile\"" + end);
            dos.writeBytes(end);

            File mFile=new File(getRealPathFromURI(headUri));
            if (mFile.exists()) {
                InputStream is = new FileInputStream(mFile);
                byte[] bytes = new byte[1024*8];
                int len = 0;
                while((len=is.read(bytes))!=-1){
                    dos.write(bytes, 0, len);
                }
                dos.writeBytes(end);
                is.close();
            }else
                System.out.println("文件不存在");

            dos.writeBytes(end);
            dos.writeBytes(twoHyphens + boundary + twoHyphens + end);
            dos.flush();
            System.out.println("请求 1：");

            int res = httpURLConnection.getResponseCode();
            if (res == 200) {
                // 读取服务器返回结果
                InputStream is = httpURLConnection.getInputStream();
                InputStreamReader isr = new InputStreamReader(is, "utf-8");
                BufferedReader br = new BufferedReader(isr);
                String result = br.readLine();
                //   Log.i("response", "" + result);
                System.out.println("请求返回：" + result);
                ret = result;
                is.close();
            }
            dos.close();
            System.out.println("请求 2：");
        } catch (Exception e) {
            e.printStackTrace();
        }

        System.out.println("返回序列："+ret);
        if(!ret.equals("")&&ret.length()>0){
            try {

                JSONObject jsonObject = new JSONObject(ret);
                final String head = jsonObject.getString("data");
                System.out.println("返回 head："+head);
                AppActivity.getInstance().runOnGLThread(new Runnable() {

                    @Override
                    public void run() {
                        Cocos2dxJavascriptJavaBridge.evalString("changeHead('"+head+"')");
                    }
                });
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        //
        System.out.println("请求调用完毕："+path);

    }



    private static final String TAG = "uploadFile";
    private static final int TIME_OUT = 30*1000;   //超时时间
    private static final String CHARSET = "utf-8"; //设置编码

    public static String uploadFile(File file, String RequestURL)
    {
        String result = null;
        String  BOUNDARY =  UUID.randomUUID().toString();  //边界标识   随机生成
        String PREFIX = "--" , LINE_END = "\r\n";
        String CONTENT_TYPE = "multipart/form-data";   //内容类型

        try {
            URL url = new URL(RequestURL);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setReadTimeout(TIME_OUT);
            conn.setConnectTimeout(TIME_OUT);
            conn.setDoInput(true);  //允许输入流
            conn.setDoOutput(true); //允许输出流
            conn.setUseCaches(false);  //不允许使用缓存
            conn.setRequestMethod("POST");  //请求方式
            conn.setRequestProperty("Charset", CHARSET);  //设置编码
            conn.setRequestProperty("connection", "keep-alive");
            conn.setRequestProperty("Content-Type", CONTENT_TYPE + ";boundary=" + BOUNDARY);

            if(file!=null)
            {
                /**
                 * 当文件不为空，把文件包装并且上传
                 */
                DataOutputStream dos = null;

                try{
                    dos = new DataOutputStream( conn.getOutputStream());
                }catch (Exception ex){

                    return result;
                }

                StringBuffer sb = new StringBuffer();
                sb.append(PREFIX);
                sb.append(BOUNDARY);
                sb.append(LINE_END);
                /**
                 * 这里重点注意：
                 * name里面的值为服务器端需要key   只有这个key 才可以得到对应的文件
                 * filename是文件的名字，包含后缀名的   比如:abc.png
                 */

                sb.append("Content-Disposition: form-data; name=\"audioFile\"; filename=\""+file.getName()+"\""+LINE_END);
                sb.append("Content-Type: application/octet-stream; charset="+CHARSET+LINE_END);
                sb.append(LINE_END);
                dos.write(sb.toString().getBytes());
                InputStream is = new FileInputStream(file);
                byte[] bytes = new byte[1024];
                int len = 0;
                while((len=is.read(bytes))!=-1)
                {
                    dos.write(bytes, 0, len);
                }
                is.close();
                dos.write(LINE_END.getBytes());
                byte[] end_data = (PREFIX+BOUNDARY+PREFIX+LINE_END).getBytes();
                dos.write(end_data);
                dos.flush();
                /**
                 * 获取响应码  200=成功
                 * 当响应成功，获取响应的流
                 */
                int res = conn.getResponseCode();

                InputStream input =  conn.getInputStream();
                StringBuffer sb1= new StringBuffer();
                int ss ;
                while((ss=input.read())!=-1)
                {
                    sb1.append((char)ss);
                }
                result = sb1.toString();

                System.out.println("返回序列："+result);
                if(!result.equals("")&&result.length()>0){
                    try {

                        JSONObject jsonObject = new JSONObject(result);
                        final String audioPath = jsonObject.getString("data");
                        System.out.println("返回 audioPath："+audioPath);
                        AppActivity.getInstance().runOnGLThread(new Runnable() {

                            @Override
                            public void run() {
                                Cocos2dxJavascriptJavaBridge.evalString("uploadAudiosuccess('"+audioPath+"')");
                            }
                        });
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void upLoadAudioFilePost(String path,File file)  {
        System.out.println("请求："+path);
        String ret ="";

        String end = "\r\n";
        String twoHyphens = "--";
        String boundary = "---------------------------823928434";
        try {
            URL url = new URL(path);
            HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);


            DataOutputStream dos = new DataOutputStream(httpURLConnection.getOutputStream());
            dos.writeBytes(twoHyphens + boundary + end);
            dos.writeBytes("Content-Disposition: form-data; type=\"file\"; filename=\""+file.getName()+"\";name=\"audioFile\"" + end);
            dos.writeBytes(end);

            File mFile=file;
            if (mFile.exists()) {
                InputStream is = new FileInputStream(mFile);
                byte[] bytes = new byte[1024*1024];
                int len = 0;
                while((len=is.read(bytes))!=-1){
                    dos.write(bytes, 0, len);
                }
                dos.writeBytes(end);
                is.close();
            }else
                System.out.println("文件不存在");

            dos.writeBytes(end);
            dos.writeBytes(twoHyphens + boundary + twoHyphens + end);
            dos.flush();
            System.out.println("请求 1：");

            int res = httpURLConnection.getResponseCode();
            if (res == 200) {
                // 读取服务器返回结果
                InputStream is = httpURLConnection.getInputStream();
                InputStreamReader isr = new InputStreamReader(is, "utf-8");
                BufferedReader br = new BufferedReader(isr);
                String result = br.readLine();
                //   Log.i("response", "" + result);
                System.out.println("请求返回：" + result);
                ret = result;
                is.close();
            }
            dos.close();
            System.out.println("请求 2：");
        } catch (Exception e) {
            e.printStackTrace();
        }

        System.out.println("返回序列："+ret);
        if(!ret.equals("")&&ret.length()>0){
            try {

                JSONObject jsonObject = new JSONObject(ret);
                final String audioPath = jsonObject.getString("data");
                System.out.println("返回 audioPath："+audioPath);
                AppActivity.getInstance().runOnGLThread(new Runnable() {

                    @Override
                    public void run() {
                        Cocos2dxJavascriptJavaBridge.evalString("uploadAudiosuccess('"+audioPath+"')");
                    }
                });
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        //
        System.out.println("请求调用完毕："+path);

    }



    private static String getRealPathFromURI(Uri contentURI) {
        String result="";
        Cursor cursor = AppActivity.getInstance().getContentResolver().query(contentURI,
                new String[]{MediaStore.Images.ImageColumns.DATA},//
                null, null, null);
        if (cursor == null) result = contentURI.getPath();
        else {
            cursor.moveToFirst();
            int index = cursor.getColumnIndex(MediaStore.Images.ImageColumns.DATA);
            result = cursor.getString(index);
            cursor.close();
        }
        return result;
    }






}
