package org.cocos2dx.javascript.voicesdk;

import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.MediaRecorder;

import org.cocos2dx.javascript.tools.HttpClientUtil;

import java.io.File;
import java.io.IOException;

public class VoiceSdkHelper {

    public static String mDirString;//保存的路径
    public static MediaRecorder mMediaRecorder;//录音的文件类
    public static File audioFile; //录音保存的文件
    public static boolean isRecoding = false;// true 表示正在录音
    private static MediaPlayer mMediaPlayer;  //播放录音文件

    public static void setStorageDir(String paramString) {
        //设置当前录音文件路径
        mDirString = paramString;
    }


    public static void prepare(String paramString) {
        File destDir = new File(mDirString);//文件保存路径
        mMediaRecorder = new MediaRecorder();
        mMediaRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);//设置播放源 麦克风
    //    Log.e("设置麦克风：", "成功");
        mMediaRecorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP); //设置输入格式 3gp
    //    Log.e("设置输入格式：", "成功");
        mMediaRecorder.setAudioEncoder(MediaRecorder.AudioEncoder.AAC); //设置编码 AMR
    //    Log.e("设置编码：", "成功");
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
   //     Log.e("创建文件路径：", "成功");
        try {
            audioFile = new File(mDirString, paramString);
            if (audioFile.exists()) {
                audioFile.delete();
      //          Log.e("删除文件路径：", "成功");
            }
            audioFile.createNewFile();
      //      Log.e("创建录音文件：", "成功");
        } catch (Exception e) {
            throw new RuntimeException("Couldn't create recording audio file", e);
        }
        mMediaRecorder.setOutputFile(audioFile.getAbsolutePath());
  //      Log.e("设置录音文件输出路径：", "成功");
        try {
            mMediaRecorder.prepare();
        } catch (IllegalStateException e) {
            throw new RuntimeException("IllegalStateException on MediaRecorder.prepare", e);
        } catch (IOException e) {
            throw new RuntimeException("IOException on MediaRecorder.prepare", e);
        }
        isRecoding = true;
        mMediaRecorder.start();
    //    Log.e("正在录音：", "成功");
       System.out.println("audio.getAbsolutePath  " +audioFile.getAbsolutePath());
    }


    public static void stopRecord() {
        if (isRecoding) {
            if (mMediaRecorder != null) {
                try {
                    mMediaRecorder.stop();
               //     Log.e("录音完成：", "成功");
                } catch (IllegalStateException e) {
                    // TODO 如果当前java状态和jni里面的状态不一致，
                    e.printStackTrace();
                    mMediaRecorder = null;
                    mMediaRecorder = new MediaRecorder();
                }
                mMediaRecorder.release();
                mMediaRecorder = null;
            }
            isRecoding =false;
            HttpClientUtil.uploadFile(audioFile, HttpClientUtil.currentHttpAudioResPath);
        }

    }


    public  static  void  UploadAudio() {
        final String dirPath = mDirString;

    }



    public static void playSound_local(){
        if(mMediaPlayer==null){
        //    Log.e("新建播放类：", "成功");
            mMediaPlayer = new MediaPlayer();
            mMediaPlayer.setOnErrorListener( new MediaPlayer.OnErrorListener() {
                @Override
                public boolean onError(MediaPlayer mp, int what, int extra) {
               //     Log.e("mMediaPlayer错误监听null：", "错误");
                    mMediaPlayer.reset();
                    return false;
                }
            });
        }else{
          //  Log.e("mMediaPlayer错误监听有值：", "成功");
            mMediaPlayer.reset();
        }

        try {
            //详见“MediaPlayer”调用过程图
            mMediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
        //    Log.e("mMediaPlayer设置类型：", "成功");
            mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){
                public void onCompletion(MediaPlayer paramAnonymousMediaPlayer) {}
            });

            mMediaPlayer.setDataSource(mDirString+"/record.mp3");
        //    Log.e("mMediaPlayer设置文件：", mDirString+"record.mp3");
            mMediaPlayer.prepare();
            mMediaPlayer.start();
        //    Log.e("mMediaPlayer开始播放：", "成功");
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        //    Log.e("语音error==",e.getMessage());
        }


    }





}
