// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {

    },


    onLoad() {
        // var me = this;

        // me.rankType = {
        //     0: 'scores',
        //     2: 'scores'
        // };

        // console.log("有没有进入1");
        // me.getData(function (d) {
        //     me.setContents([].concat(d));
        // });
    },

    onEnable() {
        var me = this;

        me.rankType = {
            0: 'scores',
            1: 'scores',
            2: 'scores'
        };
        me.getData(function (d) {
            me.setContents([].concat(d));
        });
    },

    getData: function (callback) {
        var me = this;

        me.messageData = cc.find('Canvas').getComponent('main').messageData;

        me.getMyUserInfoData(function () {
            me.getRankData(function (data) {
                callback(data);
            });
        });
    },

    getMyUserInfoData: function (callback) {
        var me = this;
        var wx = window.wx;
        //获得当前用户信息
        wx.getUserInfo({
            openIdList: ['selfOpenId'],
            success: function (res) {
                me.userData = res.data[0];
                callback();
            },
            fail: function (res) {
                console.log('获取用户信息失败============', 1);
            }
        });
    },

    getRankData: function (callback) {
        var me = this;
        var wx = window.wx;
        wx.getFriendCloudStorage({
            keyList: [me.rankType[me.messageData.messageType]],
            success: function (res) {
                var data = res.data;
                console.log('拉取排行榜数据============', data);
                data.sort(function (a, b) {
                    if (a.KVDataList.length == 0 && b.KVDataList.length == 0) {
                        return 0;
                    }
                    if (a.KVDataList.length == 0) {
                        return 1;
                    }
                    if (b.KVDataList.length == 0) {
                        return -1;
                    }
                    return b.KVDataList[0].value - a.KVDataList[0].value;
                });
                callback(data);
            },
            fail: function (res) {
                console.log('失败============', 1);
            },
        });
    },

    setContents: function (arr) {
        var me = this;
        var content = me.node.finds('Avator');
        var index = me.arrayFind(arr, me.userData.avatarUrl, "avatarUrl");
        //根据自己排名的不同设置排行榜
        if (index == 0) {
            //第一名
            var No1Node=content.finds("PlayerAvator_NO1");
            No1Node.active=true;
            No1Node.finds("RankingNode").active = true;
            No1Node.finds("RankingNode").finds("NoLabel").setString(index + 1);
            No1Node.finds("CrownSprite").active = true;
            var avatar = No1Node.finds("AvatorSprite");
            if (arr[0].avatarUrl) {
                X.getImageByUrl(arr[0].avatarUrl, function (spriteFrame) {
                    avatar.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                });
            };
            No1Node.finds("NameLabel").setString(arr[index].nickname);
            No1Node.finds("ScoresLabel").setString(arr[index].KVDataList[0].value);

            //如果后面的还存在
            if (arr[2] != null && arr[2] != "") {
                var No2Node=content.finds("PlayerAvator_NO2");
                No2Node.finds("RankingNode").active = true;
                No2Node.finds("RankingNode").finds("NoLabel").setString(index + 2);
                var avatar = No2Node.finds("AvatorSprite");
                if (arr[1].avatarUrl) {
                    X.getImageByUrl(arr[1].avatarUrl, function (spriteFrame) {
                        avatar.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                    });
                };
                No2Node.finds("NameLabel").setString(arr[index + 1].nickname);
                No2Node.finds("ScoresLabel").setString(arr[index + 1].KVDataList[0].value);


                var No3Node=content.finds("PlayerAvator_NO3")
                content.finds("PlayerAvator_NO3").finds("RankingNode").active = true;
                content.finds("PlayerAvator_NO3").finds("RankingNode").finds("NoLabel").setString(index + 3);
                var avator = content.finds("PlayerAvator_NO3").finds("AvatorSprite");
                if (arr[2].avatarUrl) {
                    X.getImageByUrl(arr[2].avatarUrl, function (spriteFrame) {
                        avator.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                    });
                };
                content.finds("PlayerAvator_NO3").finds("NameLabel").setString(arr[index + 2].nickname);
                content.finds("PlayerAvator_NO3").finds("ScoresLabel").setString(arr[index + 2].KVDataList[0].value);
            } else if (arr[1] != null && arr[1] != "") {
                var No2Node=content.finds("PlayerAvator_NO2");
                No2Node.finds("RankingNode").active = true;
                No2Node.finds("RankingNode").finds("NoLabel").setString(index + 2);
                var avatar = No2Node.finds("AvatorSprite");
                if (arr[1].avatarUrl) {
                    X.getImageByUrl(arr[1].avatarUrl, function (spriteFrame) {
                        avatar.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                    });
                };
                No2Node.finds("NameLabel").setString(arr[index + 1].nickname);
                No2Node.finds("ScoresLabel").setString(arr[index + 1].KVDataList[0].value);
            } 
        } else if (index > 0) {
            var No1Node=content.finds("PlayerAvator_NO1");
            No1Node.active=true;
            if (index <= 3) {
                No1Node.finds("RankingNode").active = true;
                No1Node.finds("RankingNode").finds("NoLabel").setString(index);
                if (index == 1) {
                    No1Node.finds("CrownSprite").active = true;
                };
            } else {
                No1Node.finds("RankingNode2").active = true;
                No1Node.finds("RankingNode2").finds("NoLabel").setString(index);
                No1Node.finds("FrameSprite1").active = false;
                No1Node.finds("FrameSprite2").active = true;
            };
            var avator = No1Node.finds("AvatorSprite");
            if (arr[index - 1].avatarUrl) {
                X.getImageByUrl(arr[index - 1].avatarUrl, function (spriteFrame) {
                    avator.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                });
            };
            No1Node.finds("NameLabel").setString(arr[index - 1].nickname);
            No1Node.finds("ScoresLabel").setString(arr[index - 1].KVDataList[0].value);

            var No2Node=content.finds("PlayerAvator_NO2");
            No2Node.active=true;
            if (index <= 2) {
                No2Node.finds("RankingNode").active = true;
                No2Node.finds("RankingNode").finds("NoLabel").setString(index + 1);
            } else {
                No2Node.finds("RankingNode2").active = true;
                No2Node.finds("RankingNode2").finds("NoLabel").setString(index + 1);
            };
            var avator = No2Node.finds("AvatorSprite");
            if (arr[index].avatarUrl) {
                X.getImageByUrl(arr[index].avatarUrl, function (spriteFrame) {
                    avator.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                });
            };
            No2Node.finds("NameLabel").setString(arr[index].nickname);
            No2Node.finds("ScoresLabel").setString(arr[index].KVDataList[0].value);

            if (arr[index + 1] != null && arr[index + 1] != "") {
                var No3Node = content.finds("PlayerAvator_NO3");
                No3Node.active = true;
                if ((index + 1) <= 2) {
                    No3Node.finds("RankingNode").active = true;
                    No3Node.finds("RankingNode").finds("NoLabel").setString(index + 2);
                } else {
                    No3Node.finds("RankingNode2").active = true;
                    No3Node.finds("RankingNode2").finds("NoLabel").setString(index + 2);
                };
                var avator = No3Node.finds("AvatorSprite");
                if (arr[index + 1].avatarUrl) {
                    X.getImageByUrl(arr[index + 1].avatarUrl, function (spriteFrame) {
                        avator.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                    });
                };
                No3Node.finds("NameLabel").setString(arr[index + 1].nickname);
                No3Node.finds("ScoresLabel").setString(arr[index + 1].KVDataList[0].value);
            };

        }
    },

    arrayFind: function (array, item, key) {
        var idx = -1;
        for (var i = 0; i < array.length; i++) {
            if (array[i] == item || array[i][key] == item) {
                idx = i;
                break;
            }
        }
        return idx;
    },



});
