
cc.Class({
    extends: cc.Component,

    properties: {
        rankPrefab:cc.Prefab
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        var me = this;

    },
    onEnable: function () {
        var me = this;

        me.getData(function (data) {
            me.setContents(data);
        });
    },

    // start () {

    // },

    // update (dt) {},
    getData: function (callback) {
        var me = this;

        me.messageData = cc.find('Canvas').getComponent('main').messageData;

        me.getMyUserInfoData(function () {
            me.getRankData(function (data) {
                callback(data);
            });
        });
    },
    getMyUserInfoData: function (callback) {
        var me = this;

        var wx = window.wx;
        //获得当前用户信息
        wx.getUserInfo({
            openIdList: ['selfOpenId'],
            success: function (res) {
                me.userData = res.data[0];

                console.log('获得个人数据============', me.userData);
                callback();
            },
            fail: function (res) {
                console.log('获取用户信息失败============', 1);
            }
        });
    },
    getRankData: function (callback) {
        var me = this;

        var wx = window.wx;
        wx.getFriendCloudStorage({
            keyList: ['historyScore'],
            success: function (res) {
                var data = res.data;
                console.log('拉取排行榜数据============', data);
                data.sort(function (a, b) {
                    if (a.KVDataList.length == 0 && b.KVDataList.length == 0) {
                        return 0;
                    }
                    if (a.KVDataList.length == 0) {
                        return 1;
                    }
                    if (b.KVDataList.length == 0) {
                        return -1;
                    }
                    return b.KVDataList[0].value - a.KVDataList[0].value;
                });
                callback(data);
            },
            fail: function (res) {
                console.log('失败============', 1);
            },
        });
    },
    setContents: function (arr) {
        var me = this;

        var txtRankTip = me.node.finds('txt_rank_tip');
        txtRankTip.hide();
        var myIdx = X.arrayFind(arr, me.userData.avatarUrl, 'avatarUrl');
        if (myIdx != -1) {
            //最近的包括自己的三个数据
            var newArr = [];
            var preData = arr[myIdx - 1] ? X.clone(arr[myIdx - 1]) : null;
            if (preData) {
                preData.rank = myIdx;
                newArr.push(preData);
            }
            var myData = arr[myIdx] ? X.clone(arr[myIdx]) : null;
            myData.rank = myIdx + 1;
            newArr.push(myData);
            var nextData = arr[myIdx + 1] ? X.clone(arr[myIdx + 1]) : null;
            if (nextData) {
                nextData.rank = myIdx + 2;
                newArr.push(nextData);
            }

            me.node.finds('lay_nearrank').removeAllChildren();
            var list = me.rankPrefab;
            for (var i = 0; i < newArr.length; i++) {
                var data = newArr[i];

                var item = cc.instantiate(list);
                item.data = data;
                item.parent = me.node.finds('lay_nearrank');
                item.getComponent('minirank_item').init();
                item.scale = 0.8;
                item.y = 0;
                item.show();
            }
        } else {
            txtRankTip.show();
        }
        
    },
});