
cc.isNode = function (node) {
    return cc.isValid(node);
};

cc.Node.prototype.touch = function() {
    var me = this;


};

//定时器调用
cc.schedule = cc.director.getScheduler();

//逐层查找节点
cc.Node.prototype.finds = function (value) {
    var me = this;

    var children = [].concat(me.children);

    if (me.nodes) {
        //查询过节点后，将部分查询结果缓存到node节点的nodes上，提供便捷查询
        if (me.nodes[value]) {
            return me.nodes[value];
        } else {
            //如果未便捷找到节点，逐层查找
            return find();
        }
    } else {
        return find();
    }


    function find() {
        if (children.length < 1) {
            return null;
        }

        var child = children.shift();

        me.nodes = me.nodes || {};
        me.nodes[child.name] = child;
        if (child.name == value) {
            return child;
        } else {
            var childchilds = [].concat(child.children);
            if (childchilds.length > 0) {
                children = children.concat(childchilds);
            }
            return find();
        }
    }
};

//省略掉canvas的书写
cc.findByPath = function (str) {
    return cc.find('Canvas/' + str);
};

//封装节点的label赋值组件
cc.Node.prototype.setString = function (str) {
    var me = this;

    var cmp = me.getComponent(cc.Label) || me.getComponent(cc.RichText);
    if (cc.isValid(cmp)) {
        cmp.string = str;

        if (cmp.useSystemFont) {
            //设置字体
            cmp.useSystemFont = false;
            cmp.font = G.DATA.ttf;
        }
    }
};

//封装节点的sprite组件
cc.Node.prototype.loadImage = function (value, args) {
    var me = this;

    var cmp = me.getComponent(cc.Sprite);

    if (cc.isValid(cmp)) {
        if (args) {
            var atlasPath = args.plist;
            cc.loader.loadRes(atlasPath, cc.SpriteAtlas, function (err, atlas) {
                if (err) {
                    console.log('err============', err);
                    return;
                }

                var frame = atlas.getSpriteFrame(value);
                cmp.spriteFrame = frame;
            });
        } else {
            var cache = G.resCache && G.resCache[value];
            if (!cache) {
                cc.loader.loadRes(value, cc.SpriteFrame, function (err, frame) {
                    if (err) {
                        console.log('err============', err);
                        return;
                    }
                    cmp.spriteFrame = frame;
                });
            } else {
                cmp.spriteFrame = cache;
            }

        }
    }
};

// 节点隐藏
cc.Node.prototype.hide = function () {
    var me = this;

    me.active = false;
};
// 节点显示
cc.Node.prototype.show = function () {
    var me = this;

    me.active = true;
};
// 节点是否是显示状态
cc.Node.prototype.isVisibe = function () {
    var me = this;

    return me.active;
};
//按钮的禁用事件
cc.Node.prototype.setTouchEnabled = function (bool) {
    var me = this;

    var cmp = me.getComponent(cc.Button);
    if (cmp) {
        //bool = true时，启用。
        cmp.interactable = bool;
        cmp.enableAutoGrayEffect = !bool;
    }
};
cc.Node.prototype.setPercent = function (value) {
    var me = this;
    var speed = 10;

    var cmp = me.getComponent(cc.ProgressBar);
    if (cc.isValid(cmp)) {
        //当前数字为0-1；
        cmp.progress = value;

        // me._from = Number(cmp.progress).toFixed(2);
        // me._to = Number(value).toFixed(2);

        // me._dtsum = 0;
        // var nv = 0;
        // cc.schedule.unscheduleUpdate();
        // cc.schedule.update = function(dt){
        //     this._dtsum += 0.01;
        //     nv = me._from + (me._to - me._from) * me._dtsum;
        //     cmp.progress = nv;
        //     if(nv == me._to){
        //         cc.schedule.unscheduleUpdate();
        //     }
        // };
        // cc.schedule.scheduleUpdate();


        // var n = 0;
        // var nv = 0;
        // var interval = 0.01;
        // var num = Math.abs(me._from - me._to) / interval;
        //
        // cmp.unscheduleAllCallbacks();
        // cmp.schedule(function () {
        //     n++;
        //     nv = Number(me._from) + n * interval * (me._to - me._from) / Math.abs(me._to - me._from);
        //     cmp.progress = nv.toFixed(2);
        //     if(n >= num){
        //         cmp.unscheduleAllCallbacks();
        //     }
        // },interval,num);

        cmp.update = function (dt) {
            var progress = cmp.progress;
            if (progress < 1.0) {
                progress += dt * speed;
            } else {
                progress -= dt * speed;
            }

            cmp.progress = progress;
        };
    }
};

