//定义全局变量
window.G = window.G || {};   //供游戏使用的全局变量
window.G.DATA = window.G.DATA || {};
window.G.DATA.player = window.G.DATA.player || {};
//设置广告类型
window.G.DATA.adType = 'wx';
(function (G) {
    G.class = G.class || {};
    G.DATA = G.DATA || {};
    //游戏名称
    G.name = 'jumpfish';
    G.canvas = function () {
        return cc.find('Canvas');
    };

    var _fun = {
        //设置节点
        sNode : function (args) {
            var prefab = args.prefab;
            if (!prefab) {
                console.log('请输入正确的参数======', 1);
                return;
            }
            var pos = args.pos || cc.v2(0,0);
            var parent = args.parent || cc.find('Canvas');

            var node = cc.instantiate(prefab);
            node.position = pos;
            node.parent = parent;

            return node;
        },
        //设置节点到parent上并显示
        addNode: function (args) {
            var parent = args.parent || cc.find('Canvas');
            var callback = args.callback;
            var name, node, prefab;
            prefab = args.prefab;

            name = prefab.name;
            node = parent.finds(name);
            if (cc.isValid(node)) {
                node.active = true;
            } else {
                G.class.sNode({
                    prefab: prefab,
                    parent:parent,
                    pos:args.pos
                });
            }

            callback && callback();
        },
        //这是个异步的
        sHead: function (data, callback) {
            var me = this;

            // data = {
            //     head:'img/mainmenu/img_tx',
            //     headboarder:'img/public/img_txk'
            // };

            var set = function (item) {
                var layIcon = item.finds('lay_icon');
                if (data.avatarUrl) {
                    X.getImageByUrl(data.avatarUrl,function (spriteFrame) {
                        layIcon.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        layIcon.scale = 0.9;
                    });
                } else {
                    layIcon.loadImage(data.head || 'img/mainmenu/img_tx');
                }

                var layKuang = item.finds('lay_kuang');
                // layKuang.loadImage('img/public/' + (data.headboarder || 'img_txk_0'));
                layKuang.hide();

                if (callback) callback(item);
            };

            var list;
            if (!cc.isValid(me.item_head)) {
                cc.loader.loadRes('prefabs/list_head', cc.Prefab, function (err, data) {
                    if (err) {
                        console.log('err============', err);
                        return ;
                    }
                    list = me.item_head = cc.instantiate(data);
                    set(list);
                });
            } else {
                list = cc.instantiate(me.item_head);
                set(list);
            }
        },
        sItem: function (data, callback) {
            var me = this;

            // data = {
            //     head:'img/mainmenu/img_tx',
            //     headboarder:'img/public/img_txk'
            // };

            var set = function (item) {

                var conf = G.class.item.getById(data.typeid);

                item.data = data;
                item.conf = conf;

                var layBg = item.finds('lay_bg');
                layBg.loadImage('img/public/' + (conf.color != undefined ? 'img_wpk_' + conf.color : 'img_wpk_0'));

                var layIcon = item.finds('lay_icon');
                layIcon.loadImage(data.head || 'img/mainmenu/img_tx');

                callback && callback(item);

                return item;
            };
            var list;
            if (!cc.isValid(me.item_item)) {
                cc.loader.loadRes('prefabs/list_item', cc.Prefab, function (err, data) {
                    list = me.item_item = cc.instantiate(data);
                    set(list);
                });
            } else {
                list = cc.instantiate(me.item_item);
                set(list);
            }
        }
    };

    for (var key in _fun) {
        G.class[key] = _fun[key];
    }
})(window.G);