window.X = window.X || {};

(function () {
    var _fun = {
        //获得某一时间戳对应的时间
        fmtStampToTime: function (time) {
            return new Date(time * 1000);
        },
        //获得当前时间戳,精确到秒
        getStamp: function () {
            var date = new Date();

            return Math.floor(date / 1000);
        },
        //缓存
        cache: function (key, value) {
            var me = this;

            if (arguments.length == 1) {
                return cc.sys.localStorage.getItem(key) ? JSON.parse(cc.sys.localStorage.getItem(key)) : cc.sys.localStorage.getItem(key);
            } else {
                cc.sys.localStorage.setItem(key, JSON.stringify(value));
            }
        },
        //清空缓存
        delCache: function (k) {
            cc.sys.localStorage.removeItem(k);
        },
        //存取当天数据
        cacheByDay: function (uid, key, value) {
            var me = this;
            //value 必须是json数据格式
            if (!key || !uid) return null;

            var date;
            if (value) {
                date = me.timetostr(G.time, 'y-m-d');
                value['date'] = date;
                if (me.cache(uid + '_' + key)) me.delCache(uid + '_' + key);
                me.cache(uid + '_' + key, JSON.stringify(value));
                return true;
            } else {
                if (!me.cache(uid + '_' + key)) return null;
                var temp = JSON.parse(me.cache(uid + '_' + key));
                date = me.timetostr(G.time, 'y-m-d');
                if (date == temp.date) {
                    temp['date'] = null;
                    delete temp['date'];
                    return temp;
                } else {
                    return false;
                }
            }
        },
        //在给定的闭区间内随机一个整数
        rand: function (start, end) {
            var value;
            if (arguments.length == 1) {
                value = Math.round(cc.random0To1() * start);
            } else {
                value = start + Math.round(cc.random0To1() * (end - start));
            }
            return value;
        },
        /*
        *******************
        *从给定闭区间随机一个指定数量的整数元素数组
        *@param start,end,num
        *@returns {arr}
        *******************
        */
        randIdxsArr: function (start, end, num) {
            var arr = [];
            for (var i = start; i < end + 1; i++) {
                arr.push(i);
            }

            arr = X.arrayShuffle(arr);
            arr.length = num;

            return arr;
        },
        timetostr: function (time, fmtStr) {
            fmtStr = fmtStr || 'y-m-d h:mm:s';
            var t = new Date(time * 1000);
            var y = t.getFullYear();
            var m = t.getMonth() + 1;
            var d = t.getDate();
            var h = t.getHours();
            var mm = t.getMinutes();
            var s = t.getSeconds();
            if (mm < 10) mm = '0' + mm;
            if (s < 10) s = '0' + s;

            fmtStr = fmtStr.replace(/y/ig, y);
            fmtStr = fmtStr.replace(/mm/ig, mm);
            fmtStr = fmtStr.replace(/m/ig, m);
            fmtStr = fmtStr.replace(/d/ig, d);
            fmtStr = fmtStr.replace(/h/ig, h);
            fmtStr = fmtStr.replace(/s/ig, s);
            return fmtStr;
        },
        //数组洗牌，随机排序
        arrayShuffle: function (arr) {
            for (var i = arr.length - 1; i > 0; i--) {
                var j = 0 | (Math.random() * (i + 1));
                var tmp = arr[i];
                arr[i] = arr[j];
                arr[j] = tmp;
            }
            return arr;
        },
        //格式化大数值
        fmtValue: function (data) {
            var v = 0;

            if (Math.floor(data / 1000) > 0) {
                v = data / 1000;
                return v.toFixed(2) + 'k';
            } else {
                return data;
            }
        },
        //数据克隆
        clone: function (data) {
            return JSON.parse(JSON.stringify(data));
        },
        getJsonTree: function (node) {
            node = node || G.canvas();

            if (!cc.isValid(node)) return;

            function getJsonTree(target) {
                if (!target || typeof target.getChildren != 'function' || target.getChildren().length == 0) return;


                console.groupCollapsed('(' + target.name + ')' + '==== ' + getCmpName(target));
                for (var i = 0; i < target.getChildren().length; i++) {
                    var child = target.getChildren()[i];
                    if (child.getChildren().length == 0) {
                        console.info('(' + child.name + ') ' + '==== ' + getCmpName(child));
                    }
                    getJsonTree(child);
                }
                console.groupEnd();
            }

            //获得组件名称
            function getCmpName(target) {
                var cmpsName = '';
                var nameArr = [];
                if (cc.isValid(target._components)) {
                    for (var i = 0; i < target._components.length; i++) {
                        var cmpName = target._components[i].name.split('<')[1].split('>')[0];
                        nameArr.push(cmpName);
                    }
                    cmpsName = nameArr.join(',');
                }

                return cmpsName;
            }

            getJsonTree(node);
        },
        //获得64位图片
        getBase64Image: function (img) {
            var canvas = document.getElementById('GameCanvas');
            canvas.width = img.width;
            canvas.height = img.height;

            var ctx = canvas.getContent('2d');
            ctx.drawImage(img, 0, 0, img.width, img.height);
            var ext = img.src.substring(img.src.lastIndexOf('.') + 1).toLowerCase();
            var dataURL = canvas.toDataURL('img/' + ext);

            return dataURL;
        },
        //获得图片的base64位格式
        // getBase64Image:function(img) {
        //     var canvas = document.createElement("canvas");
        //     canvas.width = img.width;
        //     canvas.height = img.height;
        //     var ctx = canvas.getContext("2d");
        //     ctx.drawImage(img, 0, 0, img.width, img.height);
        //     var dataURL = canvas.toDataURL("image/png");
        //
        //     return dataURL; // return dataURL.replace("data:image/png;base64,", "");
        // },
        // 截屏方法  原生的
        captureScreen: function (url) {
            //注意，EditBox，VideoPlayer，Webview 等控件无法被包含在截图里面
            //因为这是 OpenGL 的渲染到纹理的功能，上面提到的控件不是由引擎绘制的

            if (CC_JSB) {
                //如果待截图的场景中含有 mask，请使用下面注释的语句来创建 renderTexture
                // var renderTexture = cc.RenderTexture.create(1280,640, cc.Texture2D.PIXEL_FORMAT_RGBA8888, gl.DEPTH24_STENCIL8_OES);
                var renderTexture = cc.RenderTexture.create(640, 960);

                //实际截屏的代码
                renderTexture.begin();
                //this.richText.node 是我们要截图的节点，如果要截整个屏幕，可以把 this.richText 换成 Canvas 切点即可
                this.richText.node._sgNode.visit();
                renderTexture.end();
                renderTexture.saveToFile("./resources/img/demo.png", cc.ImageFormat.PNG, true, function () {
                    cc.log("capture screen successfully!");
                });
                //打印截图路径
                cc.log(jsb.fileUtils.getWritablePath());
            }
        },
        //截取当前屏幕
        captureScreenshot: function (callback) {
            function callback() {
                var canvas = document.getElementById("GameCanvas");
                var base64 = canvas.toDataURL("img/png");
                cc.director.off(cc.Director.EVENT_AFTER_DRAW);
                // var frame = this.base64ToSpriteFrame(base64, (frame) => {
                //     // console.log('frame======', frame);
                //     // this.sprite.spriteFrame = frame;
                //
                // });
                console.log('base64======', base64);
                callback && callback(base64);
            }

            cc.director.on(cc.Director.EVENT_AFTER_DRAW, callback.bind(this));
        },

        base64ToSpriteFrame: function (base64, callback) {
            var img = new Image();
            img.src = base64;
            img.onload = function () {
                var texture = new cc.Texture2D();
                texture.initWithElement(img);
                texture.handleLoadedTexture();
                var newframe = new cc.SpriteFrame(texture);
                if (callback) callback(newframe);
            }
        },
        //动画：放大并消失
        scale2big: function (node, conf) {
            if (!cc.isValid(node)) {
                console.log('参数无效======', 1);
                return;
            }

            conf = conf || {};
            var cd = conf.cd || 1;
            var act1 = cc.scaleTo(cd, 1.2);
            var act2 = cc.fadeOut(cd);
            node.runAction(cc.sequence(cc.spawn(act1, act2), cc.callFunc(function () {
                node.hide();
                node.scale = 1;
                node.opacity = 255;
            })));
        },
        //X.STR('test{1}_xx{2}',['a','b'])  ->  testa_xxb
        STR: function () {
            if (arguments.length < 2) return;
            var str = arguments[0];
            if (arguments.length == 2 && Array.isArray(arguments[1])) {
                var args = arguments[1];
                for (var i = 0; i < args.length; i++) {
                    var regx = new RegExp('\\{' + (i * 1 + 1) + '\\}', 'g');
                    str = str.replace(regx, args[i]);
                }
            } else {
                for (var i = 1; i < arguments.length; i++) {
                    var regx = new RegExp('\\{' + i + '\\}', 'g');
                    str = str.replace(regx, arguments[i]);
                }
            }
            return str;
        },
        //当前时间戳
        time: function () {
            return Math.round(new Date().getTime() / 1000);
        },
        /*
       * node = Label控件
       * toTime = 未来时间戳
       * conf = {"timeLeftStr":"h:mm:s||mm:s","showStr":"倒计时{1}"}
       * */
        timeout: function (node, toTime, endcall, stepcall, conf) {
            if (!cc.isNode(node)) return;
            conf = conf || {};
            // G.time = G.time || X.time();
            // toTime += 1;

            var setText = function () {
                var _leftSeconds = toTime - X.time();
                var _leftStr = X.timeLeft(_leftSeconds, conf.timeLeftStr);

                if (conf.showStr) _leftStr = X.STR(conf.showStr, _leftStr);

                if (conf.isNumber) {
                    _leftStr = _leftSeconds;
                }

                node.setString(_leftStr);

                stepcall && stepcall(_leftStr);

                if (X.time() >= toTime) {
                    if (node.__timeoutTimer) {
                        node.clearTimeout(node.__timeoutTimer);
                        delete node.__timeoutTimer;
                    }

                    endcall && endcall();
                    return;
                }
            };
            setText();

            if (node.__timeoutTimer) {
                node.clearInterval(node.__timeoutTimer);
                delete node.__timeoutTimer;
            }

            var _diffTime = toTime - X.time();
            if (_diffTime > 1) {
                node.__timeoutTimer = node.setInterval(function () {
                    setText();
                }, 1000);
            }

            return node.__timeoutTimer;
        },
        //将一个>0的秒数转换为h:mm:s 或者 mm:s 格式
        //fmtStr = h:mm:s || mm:s
        timeLeft: function (senconds, fmtStr) {
            fmtStr = fmtStr || "h:mm:s";
            var h = 0, mm = 0, s = 0;
            if (senconds > 0) {
                if (fmtStr.indexOf('h') != -1) {
                    h = Math.floor(senconds / 3600);
                    mm = Math.floor((senconds % 3600) / 60);
                    s = (senconds % 3600) % 60;
                } else {
                    mm = Math.floor(senconds / 60);
                    s = (senconds % 60) % 60;
                }
            }
            if (s < 10) s = '0' + s;
            fmtStr = fmtStr.replace(/mm/ig, mm);
            fmtStr = fmtStr.replace(/h/ig, h);
            fmtStr = fmtStr.replace(/s/ig, s);
            return fmtStr;
        },
        //从arr中随机取1个值
        arrayRand: function (arr) {
            return arr[X.rand(0, arr.length - 1)];
        },
        /**
         * 是否在数组中
         * @param array : Array
         * @param item : Object
         * @returns {boolean}
         */
        inArray: function (array, item) {
            if (!array) return false;
            var a = ',' + array.join(',') + ',';
            return a.indexOf(',' + item + ',') > -1;
        },
        /**
         * 在数组中找，返回下标，如果没有返回-1
         * @param array : Array
         * @param item : Object
         * @param key : String
         * @returns {number}
         */
        arrayFind: function (array, item, key) {
            var idx = -1;
            for (var i = 0; i < array.length; i++) {
                if (array[i] == item || array[i][key] == item) {
                    idx = i;
                    break;
                }
            }
            return idx;
        },
        playBgMusic: function () {
            if (G.DATA.isPlayingMusic) {
                if (G.DATA.bgMusic != undefined) {
                    X.audio.resume(G.DATA.bgMusic);
                } else {
                    G.DATA.bgMusic = X.audio.play('battle', true, 1);
                }
            } else {
                if (G.DATA.bgMusic != undefined) X.audio.pause(G.DATA.bgMusic);
            }
        },
        //通过url获得图片资源
        getImageByUrl:function (url,callback) {
            var arr = url.split(':');
            var spriteFrame;
            if (arr.length > 1) {
                //远程url
                var arr2 = url.split('.');
                if (arr2[arr2.length - 1] == 'png') {
                    cc.loader.load(url,function (err,data) {
                        if (err) {
                            console.log('err============', err);
                            return ;
                        }
                        spriteFrame = new cc.SpriteFrame(data,cc.Rect(0,0,data.width,data.height));
                        callback(spriteFrame);
                    });
                } else {
                    cc.loader.load({url:url,type:'png'},function (err,data) {
                        if (err) {
                            console.log('err============', err);
                            return;
                        }
                        spriteFrame = new cc.SpriteFrame(data, cc.Rect(0, 0, data.width,data.height));
                        callback(spriteFrame);
                    });
                }
            } else {
                //本地url
                cc.loader.loadRes(url,cc.SpriteFrame,function (err,data) {
                    callback(data);
                });
            }
        }
    };

    for (var key in _fun) {
        window.X[key] = _fun[key];
    }
})();