"use strict";
cc._RF.push(module, '5a4f81wTbBMgLO/Hk97MVqy', 'rank');
// Script/rank/rank.js

'use strict';

cc.Class({
    extends: cc.Component,

    properties: {},

    // LIFE-CYCLE CALLBACKS:

    onLoad: function onLoad() {
        var me = this;

        //好友排行榜或者群排行榜
        me.rankType = {
            1: 'historyScore',
            2: 'historyScore'
        };
    },


    onEnable: function onEnable() {
        var me = this;

        me.messageData = cc.find('Canvas').getComponent('main').messageData;

        if (me.messageData.messageType == '1') {
            me.getData(function (data) {
                me.setContents(data);
            });
        } else {
            me.getGroupRankData(1, function (data) {
                me.setContents(data);
            });
        }
    },

    // start () {
    //
    // },

    // update (dt) {},
    getData: function getData(callback) {
        var me = this;

        me.getMyUserInfoData(function () {
            me.setMyHead();
            me.getRankData(function (data) {
                callback(data);
            });
        });
    },
    getMyUserInfoData: function getMyUserInfoData(callback) {
        var me = this;

        var wx = window.wx;
        //获得当前用户信息
        wx.getUserInfo({
            openIdList: ['selfOpenId'],
            success: function success(res) {
                me.userData = res.data[0];

                console.log('获得个人数据============', me.userData);
                callback();
            },
            fail: function fail(res) {
                console.log('获取用户信息失败============', 1);
            }
        });
    },
    //获得群排行数据
    getGroupRankData: function getGroupRankData(shareTicket, callback) {
        var me = this;

        wx.getGroupCloudStorage({
            shareTicket: shareTicket,
            keyList: [me.rankType[me.messageData.messageType]],
            success: function success(res) {
                var data = res.data;
                console.log('拉取群排行榜数据============', data);
                if (data.length < 1) {
                    return;
                }
                data.sort(function (a, b) {
                    if (a.KVDataList.length == 0 && b.KVDataList.length == 0) {
                        return 0;
                    }
                    if (a.KVDataList.length == 0) {
                        return 1;
                    }
                    if (b.KVDataList.length == 0) {
                        return -1;
                    }
                    return b.KVDataList[0].value - a.KVDataList[0].value;
                });
                callback(data);
            },
            fail: function fail(res) {
                console.log('失败============', 1);
            }
        });
    },
    getRankData: function getRankData(callback) {
        var me = this;

        var wx = window.wx;

        wx.getFriendCloudStorage({
            keyList: [me.rankType[me.messageData.messageType]],
            success: function success(res) {
                var data = res.data;
                console.log('拉取排行榜数据============', data);
                data.sort(function (a, b) {
                    if (a.KVDataList.length == 0 && b.KVDataList.length == 0) {
                        return 0;
                    }
                    if (a.KVDataList.length == 0) {
                        return 1;
                    }
                    if (b.KVDataList.length == 0) {
                        return -1;
                    }
                    return b.KVDataList[0].value - a.KVDataList[0].value;
                });
                callback(data);
            },
            fail: function fail(res) {
                console.log('失败============', 1);
            }
        });
    },
    setMyHead: function setMyHead() {
        var me = this;

        var userData = me.userData;

        var layMyRank = me.node.finds('lay_myrank');
        var layIco = layMyRank.finds('lay_ico');
        // var layRank = layMyRank.finds('lay_rank');
        // var txtRank = layMyRank.finds('txt_rank');
        var txtName = layMyRank.finds('txt_name');
        // var txtScore = layMyRank.finds('txt_score');

        // layIco.removeAllChildren();

        G.class.sHead(userData, function (wid) {
            wid.position = cc.v2(0, 0);
            wid.parent = layIco;
        });

        txtName.setString(userData.nickName || 'www');
    },
    setMyRank: function setMyRank() {
        var me = this;

        var layMyRank = me.node.finds('lay_myrank');
        // var layIco = layMyRank.finds('lay_ico');
        var layRank = layMyRank.finds('lay_rank');
        var txtRank = layMyRank.finds('txt_rank');
        // var txtName = layMyRank.finds('txt_name');
        var txtScore = layMyRank.finds('txt_score');

        if (me.myRankData) {
            var rankData = me.myRankData.KVDataList[0];

            txtScore.setString(rankData.value);
            if (me.myRank * 1 < 4) {
                layRank.loadImage('img/wangguan' + me.myRank);
                layRank.show();
            }
            // else {
            //     txtRank.setString(me.myRank ? me.myRank : '未上榜');
            //     txtRank.show();
            // }
            txtRank.setString(me.myRank ? me.myRank : '未上榜');
            txtRank.show();
        } else {
            txtScore.setString(0);
            txtRank.setString('未上榜');
            txtRank.show();
        }
    },
    setContents: function setContents(arr) {
        var me = this;

        me.node.finds('txt_title').setString(me.messageData.messageType == '1' ? '好友排行榜' : '群排行榜');

        var content = me.node.finds('content');
        content.removeAllChildren();

        var list = me.node.finds('list_rank2');

        if (arr.length < 1) {
            if (cc.isValid(me.node.finds('lay_zwnr'))) me.node.finds('lay_zwnr').show();
            return;
        } else {
            if (cc.isValid(me.node.finds('lay_zwnr'))) me.node.finds('lay_zwnr').hide();
        }

        for (var i = 0; i < arr.length; i++) {
            var data = arr[i];

            var item = cc.instantiate(list);
            item.data = data;
            item.data.rank = i + 1;
            item.parent = content;
            item.show();

            if (data.avatarUrl == me.userData.avatarUrl) {
                me.myRankData = data;
                me.myRank = i + 1;
            }
        }

        //设置内容实际高度
        content.height = (item.height + content.getComponent(cc.Layout).spacingY) * arr.length;

        //需要从上面的数据中计算出我的排名
        me.setMyRank();
    }
});

cc._RF.pop();