(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/RankingControl.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '88b33V3CxFPlYD7hN8CqQJT', 'RankingControl', __filename);
// Script/RankingControl.js

'use strict';

cc.Class({
    extends: cc.Component,

    properties: {},

    onLoad: function onLoad() {
        var me = this;

        me.rankType = {
            0: 'scores',
            2: 'scores'
        };

        me.getData(function (d) {
            me.setContents([].concat(d));
        });
    },


    getData: function getData(callback) {
        var me = this;

        me.messageData = cc.find('Canvas').getComponent('main').messageData;

        me.getMyUserInfoData(function () {
            me.getRankData(function (data) {
                callback(data);
            });
        });
    },
    getMyUserInfoData: function getMyUserInfoData(callback) {
        var me = this;

        var wx = window.wx;
        //获得当前用户信息
        wx.getUserInfo({
            openIdList: ['selfOpenId'],
            success: function success(res) {
                me.userData = res.data[0];

                callback();
            },
            fail: function fail(res) {
                console.log('获取用户信息失败============', 1);
            }
        });
    },
    getRankData: function getRankData(callback) {
        var me = this;

        var wx = window.wx;
        wx.getFriendCloudStorage({
            keyList: [me.rankType[me.messageData.messageType]],
            success: function success(res) {
                var data = res.data;
                console.log('拉取排行榜数据============', data);
                data.sort(function (a, b) {
                    if (a.KVDataList.length == 0 && b.KVDataList.length == 0) {
                        return 0;
                    }
                    if (a.KVDataList.length == 0) {
                        return 1;
                    }
                    if (b.KVDataList.length == 0) {
                        return -1;
                    }
                    return b.KVDataList[0].value - a.KVDataList[0].value;
                });
                callback(data);
            },
            fail: function fail(res) {
                console.log('失败============', 1);
            }
        });
    },
    setMyRank: function setMyRank(data) {
        var me = this;
        if (!me.node.finds('PersonRanking')) {
            return;
        };
        var ranking = me.node.finds('PersonRanking').finds("ranking");
        ranking.setString(me.myRank);
        if (me.myRank * 1 == 1) {
            me.node.finds("PersonRanking").finds("CrownSprite").show();
        } else {
            me.node.finds("PersonRanking").finds("CrownSprite").hide();
        };
        var avatar = me.node.finds("PersonRanking").finds("AvatorSprite");
        if (data.avatarUrl) {
            X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                avatar.getComponent(cc.Sprite).spriteFrame = spriteFrame;
            });
        };
        var nickname = me.node.finds('PersonRanking').finds("NameLabel");
        nickname.setString(data.nickname);
        var socres = me.node.finds("PersonRanking").finds("ScoresLabel");
        socres.setString(data.KVDataList[0].value);
    },
    setContents: function setContents(arr) {
        var me = this;
        var content = me.node.finds('content');
        content.removeAllChildren();

        if (arr.length == 1) {
            var No1 = me.node.finds("RankingNO1");
            var data = arr[0];
            var avatarNode = No1.finds("PlayerAvator_NO1").finds("AvatorSprite");
            if (data.avatarUrl) {
                X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                    avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                });
            };
            No1.finds("NameLabel").setString(data.nickname);
            No1.finds("ScoresLabel").setString(data.KVDataList[0].value);

            No1.parent = content;
            No1.show();
            //设置内容实际高度
            content.height = (No1.height + content.getComponent(cc.Layout).spacingY) * arr.length;
            if (data.avatarUrl == me.userData.avatarUrl) {
                me.myRank = 1;
                //需要从上面的数据中计算出我的排名
                me.setMyRank(data);
            };
        } else if (arr.length == 2) {
            for (var i = 0; i < arr.length; i++) {
                if (i === 0) {
                    var No1 = me.node.finds("RankingNO1");
                    var data = arr[0];
                    var avatarNode = No1.finds("PlayerAvator_NO1").finds("AvatorSprite");
                    if (data.avatarUrl) {
                        X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                            avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        });
                    }
                    No1.finds("NameLabel").setString(data.nickname);
                    No1.finds("ScoresLabel").setString(data.KVDataList[0].value);

                    No1.parent = content;
                    No1.show();
                    if (data.avatarUrl == me.userData.avatarUrl) {
                        me.myRank = i + 1;
                        //需要从上面的数据中计算出我的排名
                        me.setMyRank(data);
                    };
                } else if (i === 1) {
                    var No2 = me.node.finds("RankingNO2");
                    var data = arr[1];
                    var avatarNode = No2.finds("PlayerAvator_NO2").finds("AvatorSprite");
                    if (data.avatarUrl) {
                        X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                            avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        });
                    }
                    No2.finds("NameLabel").setString(data.nickname);
                    No2.finds("ScoresLabel").setString(data.KVDataList[0].value);

                    No2.parent = content;
                    No2.show();
                    if (data.avatarUrl == me.userData.avatarUrl) {
                        me.myRank = i + 1;
                        //需要从上面的数据中计算出我的排名
                        me.setMyRank(data);
                    };
                };
            };
            //设置内容实际高度
            content.height = (109 + content.getComponent(cc.Layout).spacingY) * arr.length;
        } else if (arr.length == 3) {
            for (var i = 0; i < arr.length; i++) {
                if (i === 0) {
                    var No1 = me.node.finds("RankingNO1");
                    var data = arr[0];
                    var avatarNode = No1.finds("PlayerAvator_NO1").finds("AvatorSprite");
                    if (data.avatarUrl) {
                        X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                            avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        });
                    }
                    No1.finds("NameLabel").setString(data.nickname);
                    No1.finds("ScoresLabel").setString(data.KVDataList[0].value);

                    No1.parent = content;
                    No1.show();
                    if (data.avatarUrl == me.userData.avatarUrl) {
                        me.myRank = i + 1;
                        //需要从上面的数据中计算出我的排名
                        me.setMyRank(data);
                    };
                } else if (i === 1) {
                    var No2 = me.node.finds("RankingNO2");
                    var data = arr[1];
                    var avatarNode = No2.finds("PlayerAvator_NO2").finds("AvatorSprite");
                    if (data.avatarUrl) {
                        X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                            avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        });
                    }
                    No2.finds("NameLabel").setString(data.nickname);
                    No2.finds("ScoresLabel").setString(data.KVDataList[0].value);

                    No2.parent = content;
                    No2.show();
                    if (data.avatarUrl == me.userData.avatarUrl) {
                        me.myRank = 1;
                        //需要从上面的数据中计算出我的排名
                        me.setMyRank(data);
                    };
                } else if (i === 2) {
                    var No3 = me.node.finds("RankingNO3");
                    var data = arr[2];
                    var avatarNode = No3.finds("PlayerAvator_NO3").finds("AvatorSprite");
                    if (data.avatarUrl) {
                        X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                            avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        });
                    }
                    No3.finds("NameLabel").setString(data.nickname);
                    No3.finds("ScoresLabel").setString(data.KVDataList[0].value);

                    No3.parent = content;
                    No3.show();
                    if (data.avatarUrl == me.userData.avatarUrl) {
                        me.myRank = i + 1;
                        //需要从上面的数据中计算出我的排名
                        me.setMyRank(data);
                    };
                };
            };
            //设置内容实际高度
            content.height = (109 + content.getComponent(cc.Layout).spacingY) * arr.length;
        };

        var NoNode = me.node.finds("RankingNO");
        if (arr.length > 3) {
            for (var i = 0; i < arr.length; i++) {
                if (i === 0) {
                    var No1 = me.node.finds("RankingNO1");
                    var data = arr[0];
                    var avatarNode = No1.finds("PlayerAvator_NO1").finds("AvatorSprite");
                    if (data.avatarUrl) {
                        X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                            avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        });
                    }
                    No1.finds("NameLabel").setString(data.nickname);
                    No1.finds("ScoresLabel").setString(data.KVDataList[0].value);

                    No1.parent = content;
                    No1.show();

                    if (data.avatarUrl == me.userData.avatarUrl) {
                        me.myRank = i + 1;
                        //需要从上面的数据中计算出我的排名
                        me.setMyRank(data);
                    };
                } else if (i === 1) {
                    var No2 = me.node.finds("RankingNO2");
                    var data = arr[1];
                    var avatarNode = No2.finds("PlayerAvator_NO2").finds("AvatorSprite");
                    if (data.avatarUrl) {
                        X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                            avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        });
                    }
                    No2.finds("NameLabel").setString(data.nickname);
                    No2.finds("ScoresLabel").setString(data.KVDataList[0].value);

                    No2.parent = content;
                    No2.show();
                    if (data.avatarUrl == me.userData.avatarUrl) {
                        me.myRank = i + 1;
                        //需要从上面的数据中计算出我的排名
                        me.setMyRank(data);
                    };
                } else if (i === 2) {
                    var No3 = me.node.finds("RankingNO3");
                    var data = arr[2];
                    var avatarNode = No3.finds("PlayerAvator_NO3").finds("AvatorSprite");
                    if (data.avatarUrl) {
                        X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                            avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        });
                    }
                    No3.finds("NameLabel").setString(data.nickname);
                    No3.finds("ScoresLabel").setString(data.KVDataList[0].value);

                    No3.parent = content;
                    No3.show();
                    if (data.avatarUrl == me.userData.avatarUrl) {
                        me.myRank = i + 1;
                        //需要从上面的数据中计算出我的排名
                        me.setMyRank(data);
                    };
                } else {
                    var data = arr[i];
                    var noNode = cc.instantiate(NoNode);
                    noNode.finds("ranking").setString(i);
                    var avatarNode = noNode.finds("PlayerAvator_NO").finds("AvatorSprite");
                    if (data.avatarUrl) {
                        X.getImageByUrl(data.avatarUrl, function (spriteFrame) {
                            avatarNode.getComponent(cc.Sprite).spriteFrame = spriteFrame;
                        });
                    };
                    noNode.finds("NameLabel").setString(data.nickname);
                    noNode.finds("ScoresLabel").setString(data.KVDataList[0].value);
                    noNode.parent = content;
                    noNode.show();
                    if (data.avatarUrl == me.userData.avatarUrl) {
                        me.myRank = i + 1;
                        //需要从上面的数据中计算出我的排名
                        me.setMyRank(data);
                    };
                }
            };
            //设置内容实际高度
            content.height = (109 + content.getComponent(cc.Layout).spacingY) * arr.length;
        };
    }

});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=RankingControl.js.map
        