const {ccclass, property} = cc._decorator;

@ccclass
export default class A extends cc.Component {

    @property(cc.Node)
    button: cc.Node = null;

    @property(cc.Node)
    sprite: cc.Node = null;

    start() {
        
        this.button.on(cc.Node.EventType.TOUCH_END, () => {
            let sp = this.sprite.getComponent(cc.Sprite).spriteFrame;
            let deps = cc.loader.getDependsRecursively(sp);

            cc.director.loadScene("B", () => {

                deps.forEach(res => cc.loader.release(res));
                
            });

        });

    }

}
