const { ccclass, property } = cc._decorator;

@ccclass
export default class TestScene extends cc.Component {

    @property({ type: cc.AudioClip })
    clip: cc.AudioClip = null;

    @property(cc.Label)
    stateInfo: cc.Label = null;

    @property(cc.Label)
    audioStateInfo: cc.Label = null;
    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}
    private isPaused: boolean = false;
    private audioID: number = -1;

    start() {

    }

    onClickPlay() {
        if (this.audioID == -1) {
            this.audioID = cc.audioEngine.play(this.clip, false, 1);
            this.isPaused = false;
        }
    }

    onClickPause() {
        if (this.audioID != -1 && !this.isPaused) {
            cc.audioEngine.pause(this.audioID);
            this.isPaused = true;
        }
    }

    onClickResume() {
        if (this.audioID != -1 && this.isPaused) {
            cc.audioEngine.resume(this.audioID);
            this.isPaused = false;
        }
    }

    onClickRecreate() {
        cc.audioEngine.stopAll();
        this.audioID = cc.audioEngine.play(this.clip, false, 1);
        this.isPaused = false;
    }

    update(dt) {
        if (this.audioID != -1) {
            let duration = cc.audioEngine.getDuration(this.audioID);
            let cur = cc.audioEngine.getCurrentTime(this.audioID);
            this.stateInfo.string = "duration:" + Number(duration).toFixed(4) + ", currenttime:" + Number(cur).toFixed(4);

            let state = cc.audioEngine.getState(this.audioID)
            this.audioStateInfo.string = "AudioID = " + this.audioID + ", Audio State = " + state;
        }
    }
}
