//    Copyright (C) 2016-2019 __COMPANY_NAME
//    All rights reserved
//
//    created by zone at 2019-04-27 11:31

import {CustomMaterial} from './CustomMaterial'
import executeInEditMode = cc._decorator.executeInEditMode

const renderEngine = cc.renderer.renderEngine;
const renderer = renderEngine.renderer;
const {ccclass, property, disallowMultiple, menu} = cc._decorator

let CustomMaterial:CustomMaterial=require("CustomMaterial")

@ccclass
@disallowMultiple
@menu('Widget/ChangeHSL')
export class ChangeHSL extends cc.Component {
    @property({
        type:cc.Float,
        range:[0,360,1],
        slide:true,
    })
    get dH(): number {
        return this._dH
    }
    set dH(arg:number) {
        this._dH=arg
        this.applyShader()
    }
    @property
    _dH=0

    @property({
        type:cc.Float,
        range:[-1, 1, 0.01],
        slide:true,
    })
    get dS(): number {
        return this._dS
    }
    set dS(arg:number) {
        this._dS=arg
        this.applyShader()
    }
    @property
    _dS=0

    @property({
        type:cc.Float,
        range:[-1, 1, 0.01],
        slide:true,
    })
    get dL(): number {
        return this._dL
    }
    set dL(arg:number) {
        this._dL=arg
        this.applyShader()
    }
    @property
    _dL=0

    sprite:cc.Sprite

    onLoad() {
        this.applyShader()
    }
    _shaderObject
    applyShader(){
        if (CC_EDITOR) {
            return;
        }
        this._shaderObject = CustomMaterial.getShader("HSLshader");
        let sprite = this.sprite=this.getComponent(cc.Sprite);
        let params = this._shaderObject.params;
        let defines = this._shaderObject.defines;
        let material = sprite.getMaterial(this._shaderObject.name);

        params=[
            { name: 'u_dH', type: renderer.PARAM_FLOAT, defaultValue: this.dH },
            { name: 'u_dS', type: renderer.PARAM_FLOAT, defaultValue: this.dS },
            { name: 'u_dL', type: renderer.PARAM_FLOAT, defaultValue: this.dL },
        ]

        if (!material) {
            // noinspection TypeScriptValidateTypes
            material= new CustomMaterial(this._shaderObject.name, params, defines || []);
            sprite.setMaterial(this._shaderObject.name, material);
        }
        this.material = material;

        sprite.activateMaterial(this._shaderObject.name);

        //设置Shader参数初值
        if (params) {
            params.forEach((item) => {
                if (item.defaultValue !== undefined) {
                    material.setParamValue(item.name, item.defaultValue);
                }
            });
        }

        if (this._shaderObject.start) {
            this._shaderObject.start(sprite, material);
        }
    }

    onDestroy() {

    }
}