#include "HelloWorldScene.h"
#include "SimpleAudioEngine.h"

USING_NS_CC;

Scene* HelloWorld::createScene(const Size& designResolutionSize)
{
    return HelloWorld::create(designResolutionSize);
}

HelloWorld* HelloWorld::create(const Size& designResolutionSize)
{
    auto ret = new HelloWorld();
    ret->init(designResolutionSize);
    return ret;
}

// on "init" you need to initialize your instance
bool HelloWorld::init(const Size& designResolutionSize)
{
    //////////////////////////////
    // 1. super init first
    if ( !Scene::init() )
    {
        return false;
    }

    auto visibleSize = Director::getInstance()->getVisibleSize();
    Vec2 origin = Director::getInstance()->getVisibleOrigin();
    
    Label *designLabel = Label::createWithSystemFont(StringUtils::format("DesignResolution W=%.0f H=%.0f", designResolutionSize.width, designResolutionSize.height), "Arial", 15);
    designLabel->setPosition(origin + Vec2(visibleSize.width / 2.0f, visibleSize.height - 20));
    this->addChild(designLabel);
    
    // Add Test Menu
    Menu *menu = Menu::create();
    menu->setPosition(origin);
    this->addChild(menu);
    
    Label *testLabel = Label::createWithSystemFont("RenderTest", "Arial", 15);
    MenuItemLabel *menuItem = MenuItemLabel::create(testLabel, [=] (Ref *sender) {
        Sprite *renderSprite = Sprite::create("home_run_scratch02-2.png");
        renderSprite->setAnchorPoint(Vec2(0, 0));
        Size totalSize = renderSprite->getContentSize();
        RenderTexture *testRender = RenderTexture::create(totalSize.width, totalSize.height);
        testRender->beginWithClear(255, 0, 0, 155);
        renderSprite->visit();
        testRender->end();
        testRender->setPosition(origin + (visibleSize / 2.0f));
        this->addChild(testRender);
    });
    menuItem->setPosition(Vec2(visibleSize.width / 2.0f, visibleSize.height - 50));
    menu->addChild(menuItem);
    
    return true;
}
