module con {
	export class Main {
		public view: ui.Main;
		public root: eui.UILayer;
		public actor: dragonBones.EgretArmatureDisplay;
		public constructor(root: eui.UILayer) {
			this.root = root;
			this.setView();
		}
		setView() {
			this.view = new ui.Main();
			this.view.addEventListener(eui.UIEvent.CREATION_COMPLETE, this.initView, this);
			this.root.addChild(this.view);
		}
		initView() {
			this.view.LoadButton.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.loadActor, this);
			this.loadActor();
		}
		loadActor() {
			if (this.view.View.numChildren > 0) {
				this.actor = null;
				this.view.View.removeChildren();
			}
			let name = this.view.DBName.text;
			if (!name) {
				console.error(`this.view.DBName.text is null:${this.view.DBName.text}`);
				return;
			}
			this.actor = manager.DragonBones.Instance.getArmatureDisplayByName(name);			
			this.actor.addEventListener(egret.Event.ADDED_TO_STAGE, this.setActor, this);

			this.view.View.addChild(this.actor);
		}
		setActor() {
			this.actor.removeEventListener(egret.Event.ADDED_TO_STAGE, this.setActor, this);
			this.actor.x = this.actor.width / 2+120;
			this.actor.y = this.actor.height+120;
			let arr = this.actor.animation.animationNames;
			let btnArr = [];
			btnArr = arr.map(item => {
				let btn = new eui.Button();
				btn.label = item;
				btn.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.playAnim.bind(this), this);
				this.view.ButtonGroup.addChild(btn);
				return btn;
			}, this)
		}
		playAnim(e: egret.TouchEvent) {
			let btn: eui.Button = e.target;
			this.actor.animation.play(btn.label, 0);
			this.view.tip(`play animation:${btn.label}`);
		}
	}
}