module manager {
    export class DragonBones {
        public constructor() {
            this.armatureDic = new Map<string, dragonBones.EgretArmatureDisplay>();
        }
        private armatureDic: Map<string, dragonBones.EgretArmatureDisplay>;
        private static instance: DragonBones;
        public static get Instance() {
            if (this.instance === undefined) {
                this.instance = new DragonBones();
            }
            return this.instance;
        }
        public getArmatureDisplayByName(name: string, armatureName: string = "armatureName"): dragonBones.EgretArmatureDisplay {
            if (this.armatureDic.has(name + "@" + armatureName)) {
                return this.armatureDic[name];
            }
            const egretFactory = dragonBones.EgretFactory.factory;
            var dragonbonesData = RES.getRes(name + "_ske_json");
            var textureData = RES.getRes(name + "_tex_json");
            var texture = RES.getRes(name + "_tex_png");

            egretFactory.parseDragonBonesData(dragonbonesData);
            egretFactory.parseTextureAtlasData(textureData, texture);
            let armatureDisplay: dragonBones.EgretArmatureDisplay = egretFactory.buildArmatureDisplay(dragonbonesData.armature[0].name);
            this.armatureDic[name + "@" + armatureName] = armatureDisplay;
            armatureDisplay.animation.reset();
            return armatureDisplay;
        }
    }
}