const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.SpriteFrame)
    spritFrame: cc.SpriteFrame = null;

    @property(cc.Label)
    label: cc.Label = null;

    num: number;

    start() {
        this.num = 0;
    }

    public addOneSprite() {
        let node = new cc.Node();
        node.setParent(this.node);
        node.position = cc.v2(Math.random() * 960 - 480, Math.random() * 640 - 320);
        node.addComponent(cc.Sprite).spriteFrame = this.spritFrame;
        this.runAction(node);
        this.label.string = "" + ++this.num;
    }

    runAction(node: cc.Node) {
        let vec = cc.v2(Math.random() * 50 + 50, Math.random() * 100 + 50);
        node.runAction(cc.repeatForever(cc.sequence(
            [
                cc.callFunc(() => {
                    let position = node.convertToWorldSpaceAR(cc.v2(0, 0))
                    let visibleSize = cc.view.getVisibleSize();
                    if (position.x > visibleSize.width || position.x < 0) vec = cc.v2(-vec.x, vec.y);
                    if (position.y > visibleSize.height || position.y < 0) vec = cc.v2(vec.x, -vec.y);
                    node.runAction(cc.moveBy(0.1, vec));
                }),
                cc.delayTime(0.1),
            ]
        )));
    }
}
