const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property({ type: cc.Node })
    private root: cc.Node = null as any;

    start() {
        this._setPremutiplyAlpha(this.root);
    }


    private _setPremutiplyAlpha(root: cc.Node) {
        // 针对sprite设定premutiply
        const sprite = root.getComponent(cc.Sprite);
        if (sprite) {
            cc.log(sprite.node.name);
             sprite["srcBlendFactor"] = cc.macro.BlendFactor.ONE;
            const frame = sprite.spriteFrame;
            frame && frame.getTexture().setPremultiplyAlpha(true);
        }
        const children = root.children;
        for (let i = 0; i < children.length; i++) {
            const child = children[i];
            this._setPremutiplyAlpha(child);
        }
    }
}
