
const { ccclass, property } = cc._decorator;

@ccclass
export default class MainGameUIController extends cc.Component {

    @property(cc.Node)
    player: cc.Node = null;
    @property(cc.Node)
    btnLeft: cc.Node = null;
    @property(cc.Node)
    btnRight: cc.Node = null;
    walkLeft: boolean = false;
    walkRight: boolean = false;
    moveSpeed:number=10;
    onLoad() {
        cc.director.getCollisionManager().enabled = true;
        //cc.director.getCollisionManager().enabledDebugDraw = true;
        //cc.director.getCollisionManager().enabledDrawBoundingBox = true;
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getPhysicsManager().gravity = cc.v2(0, -640);
        //cc.director.getPhysicsManager().debugDrawFlags =1;
        this.btnLeft.on(cc.Node.EventType.TOUCH_START, function () {
            this.walkLeft = true;
            this.walkRight = false;
        }, this);
        this.btnLeft.on(cc.Node.EventType.TOUCH_END, function () {
            this.walkLeft = false;
        }, this);
        this.btnRight.on(cc.Node.EventType.TOUCH_START, function () {
            this.walkLeft = false;
            this.walkRight = true;
        }, this);
        this.btnRight.on(cc.Node.EventType.TOUCH_END, function () {
            this.walkRight = false;
        }, this);
    }

    start() {

    }

    update(dt) {
        if (this.walkLeft) {
            this.player.x -= this.moveSpeed;
        }
        if (this.walkRight) {
            this.player.x +=  this.moveSpeed;
        }
    }
}
