// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Node)
    arrowNode:cc.Node = null;

    @property(cc.Node)
    box:cc.Node = null;

    @property(cc.Node)
    oriNode:cc.Node = null;

    @property(cc.Camera)
    camera3d:cc.Camera = null;

    @property(cc.Camera)
    camera2d:cc.Camera = null;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {
        var boxPos = cc.v2(this.box.x,this.box.y);
        console.log('boxPos:' + boxPos);

        var boxCameraPos = cc.v2();
        this.camera3d.getWorldToCameraPoint(boxPos,boxCameraPos);
        console.log('boxCameraPos:' + boxCameraPos);

        var designResolution = cc.Canvas.instance.designResolution;
        console.log('designResolution:' + designResolution);

        var boxInScreenPos = new cc.Vec3();
        this.camera3d._camera.worldToScreen(boxInScreenPos,boxPos,designResolution.width,designResolution.height);
        console.log('boxInScreenPos:' + boxInScreenPos);

        this.arrowNode.position = cc.v2(boxInScreenPos.x,boxInScreenPos.y);
        this.arrowNode.parent = this.oriNode;

    }

    // update (dt) {}
}
