// Learn TypeScript:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    start() {
        this.scheduleOnce(() => {
            cc.director.loadScene("game", (scene) => {
                let canvas = cc.find("Canvas", cc.director.getScene()).getComponent(cc.Canvas);
                canvas.fitHeight = true;
                canvas.fitWidth = false;
                let content = cc.find("Canvas/content", cc.director.getScene());
                let widget = content.getComponent(cc.Widget);
                widget.isAlignTop = widget.isAlignBottom = true;
                widget.isAlignLeft = widget.isAlignRight = true;
                widget.top = 44;
                widget.bottom = 0;
                widget.left = 0;
                widget.right = 0;
                widget.updateAlignment();
            })
        }, 2)
    }
}
