import Role from "./Role";

// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class CreateItem extends cc.Component {

    @property(cc.Prefab)
    prefab: cc.Prefab = null;

    @property(Role)
    role: Role = null;

    start () {

    }

    create () {
        var size = cc.view.getDesignResolutionSize();
        var node = cc.instantiate(this.prefab);
        var item = node.getComponent("Item");
        item.role = this.role;
        node.x = Math.random() * size.width - size.width / 2;
        node.y = Math.random() * size.height - size.height / 2;
        this.node.addChild(node);
    }

    // update (dt) {}
}
