// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class Role extends cc.Component {

    @property
    speed: number = 10;

    private _targetPos: cc.Vec2 = cc.v2(0,0);

    start () {
        this._refreshTargetPos();
    }

    update (dt) {
        if (this.node.getPosition().fuzzyEquals(this._targetPos, this.speed)) {
            this._refreshTargetPos();
        }
        var direction = this._targetPos.sub(this.node.position);
        this.node.position = this.node.position.add(direction.normalize().mul(this.speed));
    }

    _refreshTargetPos ()  {
        var size = cc.view.getDesignResolutionSize();
        this._targetPos.x = Math.random() * size.width - size.width / 2;
        this._targetPos.y = Math.random() * size.height - size.height / 2;
    }
}
