(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/js/mianBack.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '728a3ACtntJlaHMMgSHekX8', 'mianBack', __filename);
// js/mianBack.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        m_peo: cc.Node,
        m_head: cc.Node,
        m_knife: cc.Prefab,
        m_cirle: cc.Node

    },

    ctor: function ctor() {
        this.array = new Array();
        this.KnifeList = new Array();
        this.num = 15;
        this.isLock = false;
        this.speed = 20;
    },


    /**
     * 创建飞刀
     */
    createKnifeNode: function createKnifeNode() {
        var enemy = null;
        if (this.array.length > 0) {
            enemy = this.array.get();
        } else {
            enemy = cc.instantiate(this.m_knife);
        }
        enemy.parent = this.m_cirle;
        //  enemy.parent = this.node; 
        this.KnifeList.push(enemy);
        return enemy;
    },


    /*
    * 求圆周上等分点的坐标
    * ox,oy为圆心坐标
    * r为半径
    * count为等分个数
    */
    getPoint: function getPoint(r, ox, oy, count) {
        var point = []; //结果
        var radians = Math.PI / 180 * Math.round(360 / count); //弧度
        //radians =60;
        cc.log("radians = " + radians);

        for (var i = 0; i < count; i++) {
            var x = ox + r * Math.sin(radians * i),
                y = oy + r * Math.cos(radians * i);
            cc.log("x = " + x + ", y = " + y);
            point.unshift({ x: x, y: y }); //为保持数据顺时针
        }
        return point;
    },

    createFiveKnifes: function createFiveKnifes(radius, srcPos, goldCount) {

        var roation = -40;
        var array = this.getPoint(radius, srcPos.x, srcPos.y, goldCount);
        for (var i = 0; i < array.length; i++) {
            if (i == array.length - 1) {
                roation = 0;
            }
            var knifeNode = this.createKnifeNode();
            knifeNode.setPosition(array[i]);
            knifeNode.rotation = roation;
            roation += -60;
        }
    },
    onLoad: function onLoad() {

        this.node.on(cc.Node.EventType.TOUCH_START, this.TouchStart.bind(this), this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.TouchMove.bind(this), this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.TouchEnd.bind(this), this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.TouchEnd.bind(this), this);

        var cilcePos = this.m_cirle.getPosition(); //圆心位置

        this.createFiveKnifes(150, cilcePos, 6);
    },

    TouchStart: function TouchStart(event, target) {},
    TouchMove: function TouchMove(event, target) {

        cc.log(this.KnifeList.length);
        var pos = event.getDelta();
        this.moveAirPlane(pos);
    },
    TouchEnd: function TouchEnd(event, target) {},
    moveAirPlane: function moveAirPlane(pos) {
        var cur_pos = this.m_peo.getPosition();
        this.m_peo.setPosition(cc.v2(cur_pos.x + pos.x, cur_pos.y + pos.y));
    },
    start: function start() {},
    update: function update(dt) {
        this.num += dt;
        console.log(this.num);
        var rotation = this.m_cirle.rotation;
        rotation += this.speed * dt;
        this.m_cirle.rotation = rotation;

        if (this.num > 20) {
            if (this.isLock) {
                return;
            } else {
                this.isLock = true;

                for (var i = 0; i < this.KnifeList.length; i++) {
                    console.log("执行一次" + this.KnifeList[i]);

                    //  var actionBy = cc.rotateBy(2, 100);
                    //  this.KnifeList[i].runAction(actionBy);
                }
                this.speed = 500;
            }
        }
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=mianBack.js.map
        