
cc.Class({
    extends: cc.Component,

    properties: {
        loading:null,
        cache:null,
    },

    onLoad: function () {
        this.loading={};
        this.cache={};
        this.loadRes = this.load;
    },

    load:function(url, type, completeCallback){
        // this.cache[url] = 1;
        // cc.loader.loadRes(url, type,completeCallback);
        // console.log("load ",url);
        if (!completeCallback && type && !cc.isChildClassOf(type, cc.RawAsset)) {
            completeCallback = type;
            type = null;
        }
        var self = this;
        if (this.cache[url] != null){
            // this.scheduleOnce(()=>{
                completeCallback(null,this.cache[url]);
            // },0);
            return;
        }
        var arr = this.loading[url];
        var first = false;
        if(arr == null){
            arr = [];
            this.loading[url] = arr;
            first = true;
        }
        arr.push(completeCallback);
        if (first) {
            cc.loader.loadRes(url, type, function (err, prefab) {
                if (err){
                    console.log("LoadRes Failed ",url);
                    delete self.loading[url];
                    return;
                }
                self.cache[url] = prefab;
                if (prefab != null){
                    prefab._createdTime = Date.now();
                }
                arr.forEach(function (x) {
                    x(err, prefab);
                });
                delete self.loading[url];
            });
        }
        //console.log("Show LoadRes isFirst:",url,first);
        // if(self.showLoadLog)
        //     console.log("Show LoadRes isFirst:",url,first);
    },
    
    

    releaseCachedRes:function (key) {
        var obj = this.cache[key];
        if (!obj){
            console.log("obj is not in cache ",key);
            return;
        }
        console.log("try to release ",key);
        delete this.cache[key];
        this.releaseObj(obj);
    },

    releaseCacheMatch(match) {
        Object.keys(this.cache).forEach(x => match(x) && this.releaseCachedRes(x));
    },



    releaseObj:function (obj) {
        var deps = cc.loader.getDependsRecursively(obj);
        for(var i=0;i<deps.length;i++){
            cc.loader.release(deps[i]);
        }
    },

    releaseAll:function () {
        var keys = Object.keys(this.cache);
        for(var i=0;i<keys.length;i++){
            this.releaseCachedRes(keys[i]);
        }
        this.cache = {};
        this.loading = {};
    },

    releaseAllUnused:function () {
        this.scheduleOnce(()=>{
            cc.sys.garbageCollect();
            this.scheduleOnce(()=>{
                if (CC_JSB){
                    cc.SpriteFrameCache.getInstance().removeUnusedSpriteFrames();
                    cc.textureCache.removeUnusedTextures();
                }
            },0);
        },0);
    },
    
});
