(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/ResourceManager.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '47c5bFd1cFJXJfp7e1Xdxui', 'ResourceManager', __filename);
// Script/ResourceManager.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        loading: null,
        cache: null
    },

    onLoad: function onLoad() {
        this.loading = {};
        this.cache = {};
        this.loadRes = this.load;
    },

    load: function load(url, type, completeCallback) {
        // this.cache[url] = 1;
        // cc.loader.loadRes(url, type,completeCallback);
        // console.log("load ",url);
        if (!completeCallback && type && !cc.isChildClassOf(type, cc.RawAsset)) {
            completeCallback = type;
            type = null;
        }
        var self = this;
        if (this.cache[url] != null) {
            // this.scheduleOnce(()=>{
            completeCallback(null, this.cache[url]);
            // },0);
            return;
        }
        var arr = this.loading[url];
        var first = false;
        if (arr == null) {
            arr = [];
            this.loading[url] = arr;
            first = true;
        }
        arr.push(completeCallback);
        if (first) {
            cc.loader.loadRes(url, type, function (err, prefab) {
                if (err) {
                    console.log("LoadRes Failed ", url);
                    delete self.loading[url];
                    return;
                }
                self.cache[url] = prefab;
                if (prefab != null) {
                    prefab._createdTime = Date.now();
                }
                arr.forEach(function (x) {
                    x(err, prefab);
                });
                delete self.loading[url];
            });
        }
        //console.log("Show LoadRes isFirst:",url,first);
        // if(self.showLoadLog)
        //     console.log("Show LoadRes isFirst:",url,first);
    },

    releaseCachedRes: function releaseCachedRes(key) {
        var obj = this.cache[key];
        if (!obj) {
            console.log("obj is not in cache ", key);
            return;
        }
        console.log("try to release ", key);
        delete this.cache[key];
        this.releaseObj(obj);
    },

    releaseCacheMatch: function releaseCacheMatch(match) {
        var _this = this;

        Object.keys(this.cache).forEach(function (x) {
            return match(x) && _this.releaseCachedRes(x);
        });
    },


    releaseObj: function releaseObj(obj) {
        var deps = cc.loader.getDependsRecursively(obj);
        for (var i = 0; i < deps.length; i++) {
            cc.loader.release(deps[i]);
        }
    },

    releaseAll: function releaseAll() {
        var keys = Object.keys(this.cache);
        for (var i = 0; i < keys.length; i++) {
            this.releaseCachedRes(keys[i]);
        }
        this.cache = {};
        this.loading = {};
    },

    releaseAllUnused: function releaseAllUnused() {
        var _this2 = this;

        this.scheduleOnce(function () {
            cc.sys.garbageCollect();
            _this2.scheduleOnce(function () {
                if (CC_JSB) {
                    cc.SpriteFrameCache.getInstance().removeUnusedSpriteFrames();
                    cc.textureCache.removeUnusedTextures();
                }
            }, 0);
        }, 0);
    }

});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=ResourceManager.js.map
        